/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.xdebugger.XSourcePosition;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="scriptDebugger.ui is deprecated")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001BE\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/debugger/SourceInfo;", "Lcom/intellij/xdebugger/XSourcePosition;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "column", "offset", "functionName", "", "url", "Lcom/intellij/util/Url;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;IIILjava/lang/String;Lcom/intellij/util/Url;)V", "getColumn", "()I", "getFunctionName", "()Ljava/lang/String;", "getUrl", "()Lcom/intellij/util/Url;", "getFile", "getLine", "getOffset", "createNavigatable", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "toString", "intellij.platform.scriptDebugger.ui"})
public final class SourceInfo
implements XSourcePosition {
    @NotNull
    private final VirtualFile file;
    private final int line;
    private final int column;
    private int offset;
    @Nullable
    private final String functionName;
    @Nullable
    private final Url url;

    @JvmOverloads
    public SourceInfo(@NotNull VirtualFile file, int line, int column, int offset, @Nullable String functionName, @Nullable Url url) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.line = line;
        this.column = column;
        this.offset = offset;
        this.functionName = functionName;
        this.url = url;
    }

    public /* synthetic */ SourceInfo(VirtualFile virtualFile, int n, int n2, int n3, String string2, Url url, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n2 = -1;
        }
        if ((n4 & 8) != 0) {
            n3 = -1;
        }
        if ((n4 & 0x10) != 0) {
            string2 = null;
        }
        if ((n4 & 0x20) != 0) {
            url = null;
        }
        this(virtualFile, n, n2, n3, string2, url);
    }

    public final int getColumn() {
        return this.column;
    }

    @Nullable
    public final String getFunctionName() {
        return this.functionName;
    }

    @Nullable
    public final Url getUrl() {
        return this.url;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        if (this.offset == -1) {
            Document document = (Document)ActionsKt.runReadAction(() -> SourceInfo.getOffset$lambda$0(this));
            if (document == null) {
                return -1;
            }
            Document document2 = document;
            this.offset = this.line < document2.getLineCount() ? document2.getLineStartOffset(this.line) : -1;
        }
        return this.offset;
    }

    @NotNull
    public OpenFileDescriptor createNavigatable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new OpenFileDescriptor(project2, this.file, this.line, this.column);
    }

    @NotNull
    public String toString() {
        return this.file.getPath() + ":" + this.line + (String)(this.column == -1 ? "" : ":" + this.column);
    }

    @JvmOverloads
    public SourceInfo(@NotNull VirtualFile file, int line, int column, int offset, @Nullable String functionName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(file, line, column, offset, functionName, null, 32, null);
    }

    @JvmOverloads
    public SourceInfo(@NotNull VirtualFile file, int line, int column, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(file, line, column, offset, null, null, 48, null);
    }

    @JvmOverloads
    public SourceInfo(@NotNull VirtualFile file, int line, int column) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(file, line, column, 0, null, null, 56, null);
    }

    @JvmOverloads
    public SourceInfo(@NotNull VirtualFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(file, line, 0, 0, null, null, 60, null);
    }

    private static final Document getOffset$lambda$0(SourceInfo this$0) {
        return this$0.file.isValid() ? FileDocumentManager.getInstance().getDocument(this$0.file) : null;
    }
}

