/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchTypedHandler;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import org.jetbrains.annotations.NotNull;

public class StructuralSearchBackspaceHandler
extends BackspaceHandlerDelegate {
    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            StructuralSearchBackspaceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            StructuralSearchBackspaceHandler.$$$reportNull$$$0(1);
        }
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            StructuralSearchBackspaceHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            StructuralSearchBackspaceHandler.$$$reportNull$$$0(3);
        }
        if (editor.getUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY) == null || !CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        if (c == '$') {
            Document document = editor.getDocument();
            CharSequence text2 = document.getCharsSequence();
            Caret caret = editor.getCaretModel().getCurrentCaret();
            int offset = caret.getOffset();
            LogicalPosition position = caret.getLogicalPosition();
            int lineStart = document.getLineStartOffset(position.line);
            int lineEnd = document.getLineEndOffset(position.line);
            if (text2.length() > offset && text2.charAt(offset) == '$' && StructuralSearchTypedHandler.hasOddDollar(text2, lineStart, lineEnd)) {
                document.deleteString(offset, offset + 1);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchBackspaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

