/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api.monitor;

import com.intellij.execution.process.OSProcessUtil;
import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.OperatingSystemMXBean;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.ThreadMXBean;
import java.lang.module.FindException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00060\u0001j\u0002`\u0002:\u0001/B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010$\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u000eJ-\u0010&\u001a\u0002H'\"\b\b\u0000\u0010'*\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H'0,H\u0002\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u00020%H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001a\u001a\u00020\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0014\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001f\u001a\u00020 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0014\u001a\u0004\b!\u0010\"\u00a8\u00060"}, d2={"Lcom/intellij/profiler/api/monitor/JavaProcessMonitor;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "pid", "", "<init>", "(I)V", "getPid", "()I", "vm", "Lcom/sun/tools/attach/VirtualMachine;", "connector", "Ljavax/management/remote/JMXConnector;", "notificationListener", "Ljavax/management/NotificationListener;", "osBean", "Lcom/sun/management/OperatingSystemMXBean;", "getOsBean", "()Lcom/sun/management/OperatingSystemMXBean;", "osBean$delegate", "Lkotlin/Lazy;", "memoryBean", "Ljava/lang/management/MemoryMXBean;", "getMemoryBean", "()Ljava/lang/management/MemoryMXBean;", "memoryBean$delegate", "threadBean", "Ljava/lang/management/ThreadMXBean;", "getThreadBean", "()Ljava/lang/management/ThreadMXBean;", "threadBean$delegate", "diagnosticBean", "Lcom/sun/management/HotSpotDiagnosticMXBean;", "getDiagnosticBean", "()Lcom/sun/management/HotSpotDiagnosticMXBean;", "diagnosticBean$delegate", "addNotificationListener", "", "getMXBean", "T", "Ljava/lang/management/PlatformManagedObject;", "beanName", "", "beanInterface", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/management/PlatformManagedObject;", "close", "Companion", "intellij.profiler.common"})
public final class JavaProcessMonitor
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int pid;
    @Nullable
    private final VirtualMachine vm;
    @Nullable
    private final JMXConnector connector;
    @Nullable
    private NotificationListener notificationListener;
    @NotNull
    private final Lazy osBean$delegate;
    @NotNull
    private final Lazy memoryBean$delegate;
    @NotNull
    private final Lazy threadBean$delegate;
    @NotNull
    private final Lazy diagnosticBean$delegate;
    @NotNull
    public static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";

    /*
     * WARNING - void declaration
     */
    private JavaProcessMonitor(int pid) {
        this.pid = pid;
        this.osBean$delegate = LazyKt.lazy(() -> JavaProcessMonitor.osBean_delegate$lambda$0(this));
        this.memoryBean$delegate = LazyKt.lazy(() -> JavaProcessMonitor.memoryBean_delegate$lambda$1(this));
        this.threadBean$delegate = LazyKt.lazy(() -> JavaProcessMonitor.threadBean_delegate$lambda$2(this));
        this.diagnosticBean$delegate = LazyKt.lazy(() -> JavaProcessMonitor.diagnosticBean_delegate$lambda$3(this));
        if (this.pid == OSProcessUtil.getCurrentProcessId()) {
            this.vm = null;
            this.connector = null;
        } else {
            JMXConnector jMXConnector;
            this.vm = VirtualMachine.attach(String.valueOf(this.pid));
            String string = this.vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
            if (string == null) {
                string = this.vm.startLocalManagementAgent();
            }
            String address = string;
            JMXConnector jMXConnector2 = jMXConnector = JMXConnectorFactory.connect(new JMXServiceURL(address));
            JavaProcessMonitor javaProcessMonitor = this;
            boolean bl = false;
            if (this.notificationListener != null) {
                void $this$_init__u24lambda_u244;
                $this$_init__u24lambda_u244.addConnectionNotificationListener(this.notificationListener, null, null);
            }
            javaProcessMonitor.connector = jMXConnector;
        }
    }

    public final int getPid() {
        return this.pid;
    }

    @NotNull
    public final OperatingSystemMXBean getOsBean() {
        Lazy lazy = this.osBean$delegate;
        return (OperatingSystemMXBean)lazy.getValue();
    }

    @NotNull
    public final MemoryMXBean getMemoryBean() {
        Lazy lazy = this.memoryBean$delegate;
        return (MemoryMXBean)lazy.getValue();
    }

    @NotNull
    public final ThreadMXBean getThreadBean() {
        Lazy lazy = this.threadBean$delegate;
        return (ThreadMXBean)lazy.getValue();
    }

    @NotNull
    public final HotSpotDiagnosticMXBean getDiagnosticBean() {
        Lazy lazy = this.diagnosticBean$delegate;
        return (HotSpotDiagnosticMXBean)lazy.getValue();
    }

    public final void addNotificationListener(@NotNull NotificationListener notificationListener) {
        Intrinsics.checkNotNullParameter((Object)notificationListener, (String)"notificationListener");
        JMXConnector jMXConnector = this.connector;
        if (jMXConnector != null) {
            jMXConnector.addConnectionNotificationListener(notificationListener, null, null);
        }
        this.notificationListener = notificationListener;
    }

    private final <T extends PlatformManagedObject> T getMXBean(String beanName, Class<T> beanInterface) {
        Object object;
        block3: {
            block2: {
                object = this.connector;
                if (object == null || (object = object.getMBeanServerConnection()) == null) break block2;
                Object server = object;
                boolean bl = false;
                PlatformManagedObject platformManagedObject = (PlatformManagedObject)ManagementFactory.newPlatformMXBeanProxy((MBeanServerConnection)server, beanName, beanInterface);
                object = platformManagedObject;
                if (platformManagedObject != null) break block3;
            }
            T t = ManagementFactory.getPlatformMXBean(beanInterface);
            object = t;
            Intrinsics.checkNotNullExpressionValue(t, (String)"getPlatformMXBean(...)");
        }
        return (T)object;
    }

    @Override
    public void close() {
        try {
            if (this.notificationListener != null) {
                JMXConnector jMXConnector = this.connector;
                if (jMXConnector != null) {
                    jMXConnector.removeConnectionNotificationListener(this.notificationListener);
                }
            }
            VirtualMachine virtualMachine = this.vm;
            if (virtualMachine != null) {
                virtualMachine.detach();
            }
            JMXConnector jMXConnector = this.connector;
            if (jMXConnector != null) {
                jMXConnector.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final OperatingSystemMXBean osBean_delegate$lambda$0(JavaProcessMonitor this$0) {
        return this$0.getMXBean("java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
    }

    private static final MemoryMXBean memoryBean_delegate$lambda$1(JavaProcessMonitor this$0) {
        return this$0.getMXBean("java.lang:type=Memory", MemoryMXBean.class);
    }

    private static final ThreadMXBean threadBean_delegate$lambda$2(JavaProcessMonitor this$0) {
        return this$0.getMXBean("java.lang:type=Threading", ThreadMXBean.class);
    }

    private static final HotSpotDiagnosticMXBean diagnosticBean_delegate$lambda$3(JavaProcessMonitor this$0) {
        return this$0.getMXBean("com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
    }

    @JvmStatic
    @NotNull
    public static final JavaProcessMonitor connect(int pid) {
        return Companion.connect(pid);
    }

    @JvmStatic
    public static final <T> T connect(int pid, @NotNull Function1<? super JavaProcessMonitor, ? extends T> block) {
        return Companion.connect(pid, block);
    }

    @JvmStatic
    @NotNull
    public static final JavaProcessMonitor getConnection(int pid) {
        return Companion.getConnection(pid);
    }

    @JvmStatic
    public static final void dumpHeap(int pid, @NotNull String filePath) throws IOException, FindException {
        Companion.dumpHeap(pid, filePath);
    }

    public /* synthetic */ JavaProcessMonitor(int pid, DefaultConstructorMarker $constructor_marker) {
        this(pid);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J/\u0010\u0006\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\n0\fH\u0007\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/api/monitor/JavaProcessMonitor$Companion;", "", "<init>", "()V", "CONNECTOR_ADDRESS", "", "connect", "Lcom/intellij/profiler/api/monitor/JavaProcessMonitor;", "pid", "", "T", "block", "Lkotlin/Function1;", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getConnection", "dumpHeap", "", "filePath", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JavaProcessMonitor connect(int pid) {
            return new JavaProcessMonitor(pid, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T connect(int pid, @NotNull Function1<? super JavaProcessMonitor, ? extends T> block) {
            Object object;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            AutoCloseable autoCloseable = new JavaProcessMonitor(pid, null);
            Throwable throwable = null;
            try {
                object = block.invoke((Object)autoCloseable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return (T)object;
        }

        @JvmStatic
        @NotNull
        public final JavaProcessMonitor getConnection(int pid) {
            return new JavaProcessMonitor(pid, null);
        }

        @JvmStatic
        public final void dumpHeap(int pid, @NotNull String filePath) throws IOException, FindException {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.connect(pid, arg_0 -> Companion.dumpHeap$lambda$0(filePath, arg_0));
        }

        private static final Unit dumpHeap$lambda$0(String $filePath, JavaProcessMonitor connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            HotSpotDiagnosticMXBean bean = connection.getDiagnosticBean();
            bean.dumpHeap($filePath, true);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

