/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToStatic;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.style.AddReturnTypeFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.EmptyDeclarationTypeCollector;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.TypeCheckVisitor;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.TypeChecker;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0005\u001a\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"MAX_FIX_ITERATIONS", "", "applyErrorFixes", "", "element", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElement;", "applyDeclarationFixes", "scope", "collectReferencedEmptyDeclarations", "", "Lcom/intellij/psi/PsiElement;", "recursive", "", "intellij.groovy"})
@JvmName(name="ConvertToStatic")
@SourceDebugExtension(value={"SMAP\nfixes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 fixes.kt\norg/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStatic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1863#2,2:108\n*S KotlinDebug\n*F\n+ 1 fixes.kt\norg/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStatic\n*L\n40#1:108,2\n*E\n"})
public final class ConvertToStatic {
    private static final int MAX_FIX_ITERATIONS = 5;

    public static final void applyErrorFixes(@NotNull GroovyPsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!element.isPhysical()) {
            return;
        }
        int n = 5;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            TypeChecker checker = new TypeChecker();
            element.accept(new TypeCheckVisitor(checker));
            PsiDocumentManager.getInstance((Project)element.getProject()).doPostponedOperationsAndUnblockDocument(element.getContainingFile().getViewProvider().getDocument());
            if (checker.applyFixes() != 0) continue;
            return;
        }
    }

    public static final void applyDeclarationFixes(@NotNull GroovyPsiElement scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        int n = 5;
        for (int j = 0; j < n; ++j) {
            int it = j;
            boolean bl = false;
            Iterable $this$forEach$iv = ConvertToStatic.collectReferencedEmptyDeclarations$default(scope, false, 2, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiType psiType;
                PsiElement element = (PsiElement)element$iv;
                boolean bl2 = false;
                PsiElement psiElement = element;
                if (psiElement instanceof GrMethod) {
                    AddReturnTypeFix.applyFix(scope.getProject(), (GrMethod)element);
                    continue;
                }
                if (!(psiElement instanceof GrVariable) || ((GrVariable)element).getTypeGroovy() == null) continue;
                ((GrVariable)element).setType(psiType);
                GrModifierList grModifierList = ((GrVariable)element).getModifierList();
                if (grModifierList == null) continue;
                grModifierList.setModifierProperty("def", false);
            }
        }
    }

    @NotNull
    public static final List<PsiElement> collectReferencedEmptyDeclarations(@NotNull GroovyPsiElement scope, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        EmptyDeclarationTypeCollector declarationsVisitor = new EmptyDeclarationTypeCollector(recursive);
        scope.accept(declarationsVisitor);
        return declarationsVisitor.getElements();
    }

    public static /* synthetic */ List collectReferencedEmptyDeclarations$default(GroovyPsiElement groovyPsiElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return ConvertToStatic.collectReferencedEmptyDeclarations(groovyPsiElement, bl);
    }
}

