/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.impl;

import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.api.DelegateArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.impl.NullArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.impl.PositionalArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.impl.VarargArgumentMapping;
import org.jetbrains.plugins.groovy.lang.sam.SamConversionKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0005\u001a\"\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\f\u001a\u00020\r\u001a(\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r\u001a*\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u001a\u0012\u0010 \u001a\u00020\u00012\b\u0010!\u001a\u0004\u0018\u00010\u0019H\u0002\u001a\u0012\u0010\"\u001a\u0004\u0018\u00010\u00192\u0006\u0010#\u001a\u00020\u0010H\u0002\u001a\u0018\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0010H\u0002\u001a\u001a\u0010'\u001a\u00020\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020(H\u0002\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\" \u0010\u0017\u001a\u0012\u0012\u000e\u0012\f0\u0019\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u001b0\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001c\"\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001f\u00a8\u0006*"}, d2={"compare", "", "X", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/CallParameter;", "left", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/ArgumentMapping;", "right", "positionalParametersDistance", "", "map", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "context", "Lcom/intellij/psi/PsiElement;", "parameterDistance", "argument", "Lcom/intellij/psi/PsiType;", "argumentCompileTime", "parameter", "parameterDistance0", "objectDistance", "PRIMITIVE_SHIFT", "OBJECT_SHIFT", "primitives", "", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "[Ljava/lang/String;", "primitiveDistances", "", "[[I", "getPrimitiveIndex", "name", "getPrimitiveName", "type", "getPrimitiveDistance", "from", "to", "getMaximumInterfaceDistance", "Lcom/intellij/psi/PsiClass;", "interfaceClass", "intellij.groovy.psi"})
public final class DistanceKt {
    private static final int PRIMITIVE_SHIFT = 21;
    private static final int OBJECT_SHIFT = 23;
    @NotNull
    private static final String[] primitives;
    @NotNull
    private static final int[][] primitiveDistances;

    public static final <X extends CallParameter> int compare(@NotNull ArgumentMapping<? extends X> left, @NotNull ArgumentMapping<? extends X> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (left instanceof DelegateArgumentMapping) {
            return DistanceKt.compare(((DelegateArgumentMapping)left).getDelegate(), right);
        }
        if (right instanceof DelegateArgumentMapping) {
            return DistanceKt.compare(left, ((DelegateArgumentMapping)right).getDelegate());
        }
        if (left instanceof NullArgumentMapping && right instanceof NullArgumentMapping) {
            return 0;
        }
        if (left instanceof NullArgumentMapping) {
            return 1;
        }
        if (right instanceof NullArgumentMapping) {
            return -1;
        }
        if (left instanceof VarargArgumentMapping && right instanceof VarargArgumentMapping) {
            return VarargArgumentMapping.Companion.compare((VarargArgumentMapping)left, (VarargArgumentMapping)right);
        }
        if (left instanceof VarargArgumentMapping) {
            return 1;
        }
        if (right instanceof VarargArgumentMapping) {
            return -1;
        }
        long leftDistance = ((PositionalArgumentMapping)left).getDistance();
        long rightDistance = ((PositionalArgumentMapping)right).getDistance();
        return leftDistance == 0L ? -1 : (rightDistance == 0L ? 1 : Intrinsics.compare((long)leftDistance, (long)rightDistance));
    }

    public static final long positionalParametersDistance(@NotNull Map<Argument, ? extends CallParameter> map2, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        long result2 = 0L;
        for (Map.Entry<Argument, ? extends CallParameter> entry : map2.entrySet()) {
            PsiType parameterType;
            PsiType runtimeType;
            Argument argument = entry.getKey();
            CallParameter parameter = entry.getValue();
            if (argument.getRuntimeType() == null || parameter.getType() == null) continue;
            result2 += DistanceKt.parameterDistance(runtimeType, argument, parameterType, context);
        }
        return result2;
    }

    public static final long parameterDistance(@NotNull PsiType argument, @Nullable Argument argumentCompileTime, @NotNull PsiType parameter, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiType psiType = TypeConversionUtil.erasure((PsiType)parameter);
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"erasure(...)");
        return DistanceKt.parameterDistance0(argument, argumentCompileTime, psiType, context);
    }

    private static final long parameterDistance0(PsiType argument, Argument argumentCompileTime, PsiType parameter, PsiElement context) {
        int dist;
        PsiClass argumentClass;
        if (Intrinsics.areEqual((Object)argument, (Object)parameter)) {
            return 0L;
        }
        PsiClassType psiClassType = parameter instanceof PsiClassType ? (PsiClassType)parameter : null;
        PsiClass parameterClass = psiClassType != null ? psiClassType.resolve() : null;
        PsiClassType psiClassType2 = argument instanceof PsiClassType ? (PsiClassType)argument : null;
        Object object = argumentClass = psiClassType2 != null ? psiClassType2.resolve() : null;
        if (Intrinsics.areEqual((Object)PsiTypes.nullType(), (Object)argument)) {
            long l;
            if (parameter instanceof PsiPrimitiveType) {
                l = 0x1000000L;
            } else {
                PsiClass psiClass = parameterClass;
                l = (psiClass != null ? psiClass.isInterface() : false) ? -1L : (long)DistanceKt.objectDistance(parameter) << 23;
            }
            return l;
        }
        if (parameterClass != null && parameterClass.isInterface() && ((dist = DistanceKt.getMaximumInterfaceDistance(argumentClass, parameterClass)) > -1 || !InheritanceUtil.isInheritor((PsiType)argument, (String)"groovy.lang.Closure"))) {
            return dist;
        }
        long objectDistance = 0L;
        int pd = DistanceKt.getPrimitiveDistance(parameter, argument);
        if (pd != -1) {
            return (long)pd << 21;
        }
        objectDistance += (long)(primitives.length + 1);
        if (argument instanceof PsiArrayType && !(parameter instanceof PsiArrayType)) {
            objectDistance += (long)4;
        }
        PsiClass argumentClass2 = argument instanceof PsiPrimitiveType ? JavaPsiFacade.getInstance((Project)context.getProject()).findClass(((PsiPrimitiveType)argument).getKind().getBoxedFqn(), context.getResolveScope()) : argumentClass;
        Integer samDistance = SamConversionKt.samDistance(argumentCompileTime, parameterClass);
        if (samDistance != null) {
            return objectDistance + (long)samDistance.intValue() << 23;
        }
        while (argumentClass2 != null && !Intrinsics.areEqual((Object)argumentClass2, (Object)parameterClass)) {
            if (Intrinsics.areEqual((Object)argumentClass2.getQualifiedName(), (Object)"groovy.lang.GString")) {
                PsiClass psiClass = parameterClass;
                if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"java.lang.String")) {
                    objectDistance += (long)2;
                    break;
                }
            }
            argumentClass2 = argumentClass2.getSuperClass();
            objectDistance += (long)3;
        }
        return objectDistance << 23;
    }

    private static final int objectDistance(PsiType parameter) {
        int psiTypeSuperTypes = parameter.getSuperTypes().length;
        int superTypesCount = parameter instanceof PsiArrayType ? psiTypeSuperTypes + 1 : psiTypeSuperTypes;
        return superTypesCount * 2;
    }

    private static final int getPrimitiveIndex(String name) {
        return ArraysKt.indexOf((Object[])primitives, (Object)name);
    }

    private static final String getPrimitiveName(PsiType type) {
        String string;
        PsiType psiType = type;
        if (psiType instanceof PsiPrimitiveType) {
            string = ((PsiPrimitiveType)type).getKind().getName();
        } else if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            string = psiClass != null ? psiClass.getQualifiedName() : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final int getPrimitiveDistance(PsiType from, PsiType to) {
        int fromIndex = DistanceKt.getPrimitiveIndex(DistanceKt.getPrimitiveName(from));
        if (fromIndex < 0) {
            return -1;
        }
        int toIndex = DistanceKt.getPrimitiveIndex(DistanceKt.getPrimitiveName(to));
        if (toIndex < 0) {
            return -1;
        }
        return primitiveDistances[toIndex][fromIndex];
    }

    private static final int getMaximumInterfaceDistance(PsiClass argument, PsiClass interfaceClass) {
        if (argument == null) {
            return -1;
        }
        if (argument.isEquivalentTo((PsiElement)interfaceClass)) {
            return 0;
        }
        PsiClass[] psiClassArray = argument.getInterfaces();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getInterfaces(...)");
        PsiClass[] interfaces = psiClassArray;
        int max = -1;
        for (PsiClass anInterface : interfaces) {
            int sub = DistanceKt.getMaximumInterfaceDistance(anInterface, interfaceClass);
            if (sub != -1) {
                ++sub;
            }
            max = Math.max(max, sub);
        }
        int superClassMax = DistanceKt.getMaximumInterfaceDistance(argument.getSuperClass(), interfaceClass);
        if (superClassMax != -1) {
            ++superClassMax;
        }
        return Math.max(max, superClassMax);
    }

    static {
        Object object = new String[]{JvmPrimitiveTypeKind.BOOLEAN.getName(), JvmPrimitiveTypeKind.BOOLEAN.getBoxedFqn(), JvmPrimitiveTypeKind.BYTE.getName(), JvmPrimitiveTypeKind.BYTE.getBoxedFqn(), JvmPrimitiveTypeKind.SHORT.getName(), JvmPrimitiveTypeKind.SHORT.getBoxedFqn(), JvmPrimitiveTypeKind.CHAR.getName(), JvmPrimitiveTypeKind.CHAR.getBoxedFqn(), JvmPrimitiveTypeKind.INT.getName(), JvmPrimitiveTypeKind.INT.getBoxedFqn(), JvmPrimitiveTypeKind.LONG.getName(), JvmPrimitiveTypeKind.LONG.getBoxedFqn(), "java.math.BigInteger", JvmPrimitiveTypeKind.FLOAT.getName(), JvmPrimitiveTypeKind.FLOAT.getBoxedFqn(), JvmPrimitiveTypeKind.DOUBLE.getName(), JvmPrimitiveTypeKind.DOUBLE.getBoxedFqn(), "java.math.BigDecimal", "java.lang.Number", "java.lang.Object"};
        primitives = object;
        object = new int[20][];
        int[] nArray = new int[]{0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 2};
        object[0] = nArray;
        nArray = new int[]{1, 0, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 2};
        object[1] = nArray;
        nArray = new int[]{18, 19, 0, 1, 2, 3, 16, 17, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        object[2] = nArray;
        nArray = new int[]{18, 19, 1, 0, 2, 3, 16, 17, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        object[3] = nArray;
        nArray = new int[]{18, 19, 14, 15, 0, 1, 16, 17, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
        object[4] = nArray;
        nArray = new int[]{18, 19, 14, 15, 1, 0, 16, 17, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
        object[5] = nArray;
        nArray = new int[]{18, 19, 16, 17, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
        object[6] = nArray;
        nArray = new int[]{18, 19, 16, 17, 14, 15, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
        object[7] = nArray;
        nArray = new int[]{18, 19, 14, 15, 12, 13, 16, 17, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        object[8] = nArray;
        nArray = new int[]{18, 19, 14, 15, 12, 13, 16, 17, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        object[9] = nArray;
        nArray = new int[]{18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        object[10] = nArray;
        nArray = new int[]{18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9};
        object[11] = nArray;
        nArray = new int[]{18, 19, 9, 10, 7, 8, 16, 17, 5, 6, 3, 4, 0, 14, 15, 12, 13, 11, 1, 2};
        object[12] = nArray;
        nArray = new int[]{18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 0, 1, 2, 3, 4, 5, 6};
        object[13] = nArray;
        nArray = new int[]{18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 1, 0, 2, 3, 4, 5, 6};
        object[14] = nArray;
        nArray = new int[]{18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 5, 6, 0, 1, 2, 3, 4};
        object[15] = nArray;
        nArray = new int[]{18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 5, 6, 1, 0, 2, 3, 4};
        object[16] = nArray;
        nArray = new int[]{18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 5, 6, 3, 4, 0, 1, 2};
        object[17] = nArray;
        nArray = new int[]{18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 5, 6, 3, 4, 2, 0, 1};
        object[18] = nArray;
        nArray = new int[]{18, 19, 14, 15, 12, 13, 16, 17, 10, 11, 8, 9, 7, 5, 6, 3, 4, 2, 1, 0};
        object[19] = nArray;
        primitiveDistances = (int[][])object;
    }
}

