/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.auto.reload;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemModificationType;
import com.intellij.openapi.externalSystem.autoimport.changes.AsyncFilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.settings.AsyncSupplier;
import com.intellij.openapi.externalSystem.autoimport.settings.ReadAsyncSupplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.MavenSyncSpec;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\n \n*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/maven/project/auto/reload/MavenGeneralSettingsWatcher;", "", "manager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "backgroundExecutor", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Lorg/jetbrains/idea/maven/project/MavenProjectsManager;Ljava/util/concurrent/ExecutorService;)V", "generalSettings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "kotlin.jvm.PlatformType", "getGeneralSettings", "()Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "embeddersManager", "Lorg/jetbrains/idea/maven/project/MavenEmbeddersManager;", "getEmbeddersManager", "()Lorg/jetbrains/idea/maven/project/MavenEmbeddersManager;", "collectSettingsFiles", "", "", "fireSettingsChange", "", "fireSettingsXmlChange", "subscribeOnSettingsChanges", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "subscribeOnSettingsFileChanges", "intellij.maven"})
@ApiStatus.Internal
public final class MavenGeneralSettingsWatcher {
    @NotNull
    private final MavenProjectsManager manager;
    @NotNull
    private final ExecutorService backgroundExecutor;

    public MavenGeneralSettingsWatcher(@NotNull MavenProjectsManager manager, @NotNull ExecutorService backgroundExecutor) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)backgroundExecutor, (String)"backgroundExecutor");
        this.manager = manager;
        this.backgroundExecutor = backgroundExecutor;
    }

    private final MavenGeneralSettings getGeneralSettings() {
        return this.manager.getGeneralSettings();
    }

    private final MavenEmbeddersManager getEmbeddersManager() {
        return this.manager.getEmbeddersManager();
    }

    private final Set<String> collectSettingsFiles() {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        File file = MavenUtil.resolveUserSettingsFile(this.getGeneralSettings().getUserSettingsFile());
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resolveUserSettingsFile(...)");
        File userSettingsFile = file;
        Path path = userSettingsFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        result2.add(NioPathUtil.toCanonicalPath((Path)path));
        return result2;
    }

    private final void fireSettingsChange() {
        this.getEmbeddersManager().reset();
        Project project = this.manager.getProject();
        MavenDistributionsCache.getInstance(project).cleanCaches();
        this.manager.scheduleUpdateAllMavenProjects(MavenSyncSpec.Companion.full$default(MavenSyncSpec.Companion, "MavenGeneralSettingsWatcher.fireSettingsChange", false, 2, null));
    }

    private final void fireSettingsXmlChange() {
        this.getGeneralSettings().changed();
    }

    public final void subscribeOnSettingsChanges(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.getGeneralSettings().addListener(this::fireSettingsChange, parentDisposable);
    }

    public final void subscribeOnSettingsFileChanges(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Object[] objectArray = new Object[]{this};
        AsyncSupplier filesProvider2 = new ReadAsyncSupplier.Builder((Function0)new Function0<Set<? extends String>>((Object)this){

            public final Set<String> invoke() {
                return MavenGeneralSettingsWatcher.access$collectSettingsFiles((MavenGeneralSettingsWatcher)this.receiver);
            }
        }).coalesceBy(objectArray).build((Executor)this.backgroundExecutor);
        AsyncFilesChangesListener.Companion.subscribeOnVirtualFilesChanges(false, filesProvider2, new FilesChangesListener(this){
            final /* synthetic */ MavenGeneralSettingsWatcher this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFileChange(String path, long modificationStamp, ExternalSystemModificationType modificationType) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)modificationType, (String)"modificationType");
                String fileChangeMessage = "File change: " + path + ", " + modificationStamp + ", " + modificationType;
                MavenLog.LOG.debug(fileChangeMessage);
            }

            public void apply() {
                MavenGeneralSettingsWatcher.access$fireSettingsXmlChange(this.this$0);
            }
        }, parentDisposable);
    }

    public static final /* synthetic */ Set access$collectSettingsFiles(MavenGeneralSettingsWatcher $this) {
        return $this.collectSettingsFiles();
    }

    public static final /* synthetic */ void access$fireSettingsXmlChange(MavenGeneralSettingsWatcher $this) {
        $this.fireSettingsXmlChange();
    }
}

