/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public final class DecHelper {
    public static boolean checkStatementExceptions(List<? extends Statement> lst) {
        HashSet<? extends Statement> all = new HashSet<Statement>(lst);
        HashSet<Statement> handlers = new HashSet<Statement>();
        Set<Statement> intersection = null;
        for (Statement statement : lst) {
            Set<Statement> setNew = statement.getNeighboursSet(StatEdge.EdgeType.EXCEPTION, StatEdge.EdgeDirection.FORWARD);
            if (intersection == null) {
                intersection = setNew;
                continue;
            }
            HashSet<Statement> interclone = new HashSet<Statement>(intersection);
            interclone.removeAll(setNew);
            intersection.retainAll(setNew);
            setNew.removeAll(intersection);
            handlers.addAll(interclone);
            handlers.addAll(setNew);
        }
        for (Statement statement : handlers) {
            if (all.contains(statement) && all.containsAll(statement.getNeighbours(StatEdge.EdgeType.EXCEPTION, StatEdge.EdgeDirection.BACKWARD))) continue;
            return false;
        }
        for (int i = 1; i < lst.size(); ++i) {
            Statement statement = lst.get(i);
            if (statement.getPredecessorEdges(StatEdge.EdgeType.EXCEPTION).isEmpty() || handlers.contains(statement)) continue;
            return false;
        }
        return true;
    }

    public static boolean isChoiceStatement(Statement head, List<? super Statement> lst) {
        boolean repeat;
        Statement post = null;
        Set<Statement> setDest = head.getNeighboursSet(StatEdge.EdgeType.REGULAR, StatEdge.EdgeDirection.FORWARD);
        if (setDest.contains(head)) {
            return false;
        }
        block0: do {
            lst.clear();
            repeat = false;
            setDest.remove(post);
            for (Statement stat : setDest) {
                StatEdge edge;
                List<StatEdge> lstEdges;
                if (stat.getLastBasicType() != Statement.StatementType.GENERAL) {
                    if (post == null) {
                        post = stat;
                        repeat = true;
                        continue block0;
                    }
                    return false;
                }
                Set<Statement> setPred = stat.getNeighboursSet(StatEdge.EdgeType.REGULAR, StatEdge.EdgeDirection.BACKWARD);
                setPred.remove(head);
                if (setPred.contains(stat)) {
                    return false;
                }
                if (!setDest.containsAll(setPred) || setPred.size() > 1) {
                    if (post == null) {
                        post = stat;
                        repeat = true;
                        continue block0;
                    }
                    return false;
                }
                if (setPred.size() == 1) {
                    Statement pred = setPred.iterator().next();
                    while (lst.contains(pred)) {
                        Set<Statement> setPredTemp = pred.getNeighboursSet(StatEdge.EdgeType.REGULAR, StatEdge.EdgeDirection.BACKWARD);
                        setPredTemp.remove(head);
                        if (setPredTemp.isEmpty()) break;
                        pred = setPredTemp.iterator().next();
                        if (pred != stat) continue;
                        return false;
                    }
                }
                if ((lstEdges = stat.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL)).size() > 1) {
                    Set<Statement> setSucc = stat.getNeighboursSet(StatEdge.EdgeType.DIRECT_ALL, StatEdge.EdgeDirection.FORWARD);
                    setSucc.retainAll(setDest);
                    if (setSucc.size() > 0) {
                        return false;
                    }
                    if (post == null) {
                        post = stat;
                        repeat = true;
                        continue block0;
                    }
                    return false;
                }
                if (lstEdges.size() == 1 && (edge = lstEdges.get(0)).getType() == StatEdge.EdgeType.REGULAR) {
                    Statement statd = edge.getDestination();
                    if (head == statd) {
                        return false;
                    }
                    if (post != statd && !setDest.contains(statd)) {
                        if (post != null) {
                            return false;
                        }
                        Set<Statement> set = statd.getNeighboursSet(StatEdge.EdgeType.REGULAR, StatEdge.EdgeDirection.BACKWARD);
                        if (set.size() > 1) {
                            post = statd;
                            repeat = true;
                            continue block0;
                        }
                        return false;
                    }
                }
                lst.add(stat);
            }
        } while (repeat);
        lst.add(head);
        lst.remove(post);
        lst.add(0, post);
        return true;
    }

    public static Set<Statement> getUniquePredExceptions(Statement head) {
        HashSet<Statement> setHandlers = new HashSet<Statement>(head.getNeighbours(StatEdge.EdgeType.EXCEPTION, StatEdge.EdgeDirection.FORWARD));
        setHandlers.removeIf(statement -> statement.getPredecessorEdges(StatEdge.EdgeType.EXCEPTION).size() > 1);
        return setHandlers;
    }

    public static boolean invalidHeadMerge(Statement head) {
        Statement ifhead = DecHelper.findIfHead(head);
        return ifhead != null && head.getContinueSet().contains(ifhead.getFirst());
    }

    private static Statement findIfHead(Statement head) {
        while (head != null && head.type != Statement.StatementType.IF) {
            if (head.type != Statement.StatementType.SEQUENCE) {
                return null;
            }
            head = head.getFirst();
        }
        return head;
    }

    public static List<Exprent> copyExprentList(List<? extends Exprent> lst) {
        ArrayList<Exprent> ret = new ArrayList<Exprent>();
        for (Exprent exprent : lst) {
            ret.add(exprent.copy());
        }
        return ret;
    }
}

