/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.dsl.impl.java;

import com.intellij.debugger.streams.trace.dsl.Types;
import com.intellij.debugger.streams.trace.impl.handler.type.ArrayType;
import com.intellij.debugger.streams.trace.impl.handler.type.ArrayTypeImpl;
import com.intellij.debugger.streams.trace.impl.handler.type.ClassTypeImpl;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericTypeImpl;
import com.intellij.debugger.streams.trace.impl.handler.type.ListType;
import com.intellij.debugger.streams.trace.impl.handler.type.ListTypeImpl;
import com.intellij.debugger.streams.trace.impl.handler.type.MapType;
import com.intellij.debugger.streams.trace.impl.handler.type.MapTypeImpl;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005H\u0016J!\u0010#\u001a\u00020\u00052\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050%\u00a2\u0006\u0002\b&H\u0016J\u000e\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u000202J\u0010\u00108\u001a\u0002092\u0006\u00107\u001a\u00020\u0005H\u0003J\u000e\u0010:\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u0005R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0014\u0010\u0014\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0014\u0010\u0016\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u000e\u0010'\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010+\u001a&\u0012\f\u0012\n -*\u0004\u0018\u00010\u00050\u0005 -*\u0012\u0012\f\u0012\n -*\u0004\u0018\u00010\u00050\u0005\u0018\u00010.0,X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010/\u00a8\u0006;"}, d2={"Lcom/intellij/debugger/streams/trace/dsl/impl/java/JavaTypes;", "Lcom/intellij/debugger/streams/trace/dsl/Types;", "<init>", "()V", "ANY", "Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;", "getANY", "()Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;", "INT", "getINT", "BOOLEAN", "getBOOLEAN", "DOUBLE", "getDOUBLE", "EXCEPTION", "getEXCEPTION", "VOID", "getVOID", "TIME", "getTIME", "STRING", "getSTRING", "LONG", "getLONG", "array", "Lcom/intellij/debugger/streams/trace/impl/handler/type/ArrayType;", "elementType", "map", "Lcom/intellij/debugger/streams/trace/impl/handler/type/MapType;", "keyType", "valueType", "linkedMap", "list", "Lcom/intellij/debugger/streams/trace/impl/handler/type/ListType;", "elementsType", "nullable", "typeSelector", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "optional", "optionalInt", "optionalLong", "optionalDouble", "OPTIONAL_TYPES", "", "kotlin.jvm.PlatformType", "", "Ljava/util/Set;", "fromStreamPsiType", "streamPsiType", "Lcom/intellij/psi/PsiType;", "fromPsiClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "fromPsiType", "type", "isOptional", "", "unwrapOptional", "intellij.java.debugger.streams"})
public final class JavaTypes
implements Types {
    @NotNull
    public static final JavaTypes INSTANCE = new JavaTypes();
    @NotNull
    private static final GenericType ANY = new ClassTypeImpl("java.lang.Object", "new java.lang.Object()");
    @NotNull
    private static final GenericType INT = new GenericTypeImpl("int", "java.lang.Integer", "0");
    @NotNull
    private static final GenericType BOOLEAN = new GenericTypeImpl("boolean", "java.lang.Boolean", "false");
    @NotNull
    private static final GenericType DOUBLE = new GenericTypeImpl("double", "java.lang.Double", "0.");
    @NotNull
    private static final GenericType EXCEPTION = new ClassTypeImpl("java.lang.Throwable", null, 2, null);
    @NotNull
    private static final GenericType VOID = new GenericTypeImpl("void", "java.lang.Void", "null");
    @NotNull
    private static final GenericType TIME = new ClassTypeImpl("java.util.concurrent.atomic.AtomicInteger", "new java.util.concurrent.atomic.AtomicInteger()");
    @NotNull
    private static final GenericType STRING = new ClassTypeImpl("java.lang.String", "\"\"");
    @NotNull
    private static final GenericType LONG = new GenericTypeImpl("long", "java.lang.Long", "0L");
    @NotNull
    private static final GenericType optional = new ClassTypeImpl("java.util.Optional", null, 2, null);
    @NotNull
    private static final GenericType optionalInt = new ClassTypeImpl("java.util.OptionalInt", null, 2, null);
    @NotNull
    private static final GenericType optionalLong = new ClassTypeImpl("java.util.OptionalLong", null, 2, null);
    @NotNull
    private static final GenericType optionalDouble = new ClassTypeImpl("java.util.OptionalDouble", null, 2, null);
    private static final Set<GenericType> OPTIONAL_TYPES;

    private JavaTypes() {
    }

    @Override
    @NotNull
    public GenericType getANY() {
        return ANY;
    }

    @Override
    @NotNull
    public GenericType getINT() {
        return INT;
    }

    @Override
    @NotNull
    public GenericType getBOOLEAN() {
        return BOOLEAN;
    }

    @Override
    @NotNull
    public GenericType getDOUBLE() {
        return DOUBLE;
    }

    @Override
    @NotNull
    public GenericType getEXCEPTION() {
        return EXCEPTION;
    }

    @Override
    @NotNull
    public GenericType getVOID() {
        return VOID;
    }

    @Override
    @NotNull
    public GenericType getTIME() {
        return TIME;
    }

    @Override
    @NotNull
    public GenericType getSTRING() {
        return STRING;
    }

    @Override
    @NotNull
    public GenericType getLONG() {
        return LONG;
    }

    @Override
    @NotNull
    public ArrayType array(@NotNull GenericType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        return new ArrayTypeImpl(elementType, (Function1<? super String, String>)((Function1)JavaTypes::array$lambda$0), (Function1<? super String, String>)((Function1)arg_0 -> JavaTypes.array$lambda$1(elementType, arg_0)));
    }

    @Override
    @NotNull
    public MapType map(@NotNull GenericType keyType, @NotNull GenericType valueType) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        return new MapTypeImpl(keyType, valueType, (Function2<? super String, ? super String, String>)((Function2)JavaTypes::map$lambda$2), "new java.util.HashMap<>()");
    }

    @Override
    @NotNull
    public MapType linkedMap(@NotNull GenericType keyType, @NotNull GenericType valueType) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        return new MapTypeImpl(keyType, valueType, (Function2<? super String, ? super String, String>)((Function2)JavaTypes::linkedMap$lambda$3), "new java.util.LinkedHashMap<>()");
    }

    @Override
    @NotNull
    public ListType list(@NotNull GenericType elementsType) {
        Intrinsics.checkNotNullParameter((Object)elementsType, (String)"elementsType");
        return new ListTypeImpl(elementsType, (Function1<? super String, String>)((Function1)JavaTypes::list$lambda$4), "new java.util.ArrayList<>()");
    }

    @Override
    @NotNull
    public GenericType nullable(@NotNull Function1<? super Types, ? extends GenericType> typeSelector) {
        Intrinsics.checkNotNullParameter(typeSelector, (String)"typeSelector");
        return (GenericType)typeSelector.invoke((Object)this);
    }

    @NotNull
    public final GenericType fromStreamPsiType(@NotNull PsiType streamPsiType) {
        Intrinsics.checkNotNullParameter((Object)streamPsiType, (String)"streamPsiType");
        return InheritanceUtil.isInheritor((PsiType)streamPsiType, (String)"java.util.stream.IntStream") ? this.getINT() : (InheritanceUtil.isInheritor((PsiType)streamPsiType, (String)"java.util.stream.LongStream") ? this.getLONG() : (InheritanceUtil.isInheritor((PsiType)streamPsiType, (String)"java.util.stream.DoubleStream") ? this.getDOUBLE() : (Intrinsics.areEqual((Object)PsiTypes.voidType(), (Object)streamPsiType) ? this.getVOID() : this.getANY())));
    }

    @NotNull
    public final GenericType fromPsiClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.stream.IntStream") ? this.getINT() : (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.stream.LongStream") ? this.getLONG() : (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.stream.DoubleStream") ? this.getDOUBLE() : this.getANY()));
    }

    @NotNull
    public final GenericType fromPsiType(@NotNull PsiType type) {
        GenericType genericType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        PsiType psiType = type;
        if (Intrinsics.areEqual((Object)psiType, (Object)PsiTypes.voidType())) {
            genericType = this.getVOID();
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiTypes.intType())) {
            genericType = this.getINT();
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiTypes.doubleType())) {
            genericType = this.getDOUBLE();
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiTypes.longType())) {
            genericType = this.getLONG();
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiTypes.booleanType())) {
            genericType = this.getBOOLEAN();
        } else {
            String string = TypeConversionUtil.erasure((PsiType)type).getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
            genericType = new ClassTypeImpl(string, null, 2, null);
        }
        return genericType;
    }

    @Contract(pure=true)
    private final boolean isOptional(GenericType type) {
        return OPTIONAL_TYPES.contains(type);
    }

    @NotNull
    public final GenericType unwrapOptional(@NotNull GenericType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean bl = this.isOptional(type);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        GenericType genericType = type;
        return Intrinsics.areEqual((Object)genericType, (Object)optionalInt) ? this.getINT() : (Intrinsics.areEqual((Object)genericType, (Object)optionalLong) ? this.getLONG() : (Intrinsics.areEqual((Object)genericType, (Object)optionalDouble) ? this.getDOUBLE() : this.getANY()));
    }

    private static final String array$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + "[]";
    }

    private static final String array$lambda$1(GenericType $elementType, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "new " + $elementType.getVariableTypeName() + "[" + it + "]";
    }

    private static final String map$lambda$2(String keys, String values) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return "java.util.Map<" + keys + ", " + values + ">";
    }

    private static final String linkedMap$lambda$3(String keys, String values) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return "java.util.Map<" + keys + ", " + values + ">";
    }

    private static final String list$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "java.util.List<" + it + ">";
    }

    static {
        Object[] objectArray = new GenericType[]{optional, optionalInt, optionalLong, optionalDouble};
        OPTIONAL_TYPES = StreamEx.of((Object[])objectArray).toSet();
    }
}

