/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import io.ktor.http.cio.internals.AsciiCharTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0003\b\u0000\u0018\u0000 \u0014*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0002\u0014\u0015B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005JL\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u0012R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lio/ktor/http/cio/internals/AsciiCharTree;", "T", "", "root", "Lio/ktor/http/cio/internals/AsciiCharTree$Node;", "(Lio/ktor/http/cio/internals/AsciiCharTree$Node;)V", "getRoot", "()Lio/ktor/http/cio/internals/AsciiCharTree$Node;", "search", "", "sequence", "", "fromIdx", "", "end", "lowerCase", "", "stopPredicate", "Lkotlin/Function2;", "", "Companion", "Node", "ktor-http-cio"})
public final class AsciiCharTree<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Node<T> root;

    public AsciiCharTree(@NotNull Node<T> root) {
        Intrinsics.checkNotNullParameter(root, (String)"root");
        this.root = root;
    }

    @NotNull
    public final Node<T> getRoot() {
        return this.root;
    }

    @NotNull
    public final List<T> search(@NotNull CharSequence sequence, int fromIdx, int end, boolean lowerCase, @NotNull Function2<? super Character, ? super Integer, Boolean> stopPredicate) {
        Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
        Intrinsics.checkNotNullParameter(stopPredicate, (String)"stopPredicate");
        if (sequence.length() == 0) {
            throw new IllegalArgumentException("Couldn't search in char tree for empty string");
        }
        Node<T> node = this.root;
        for (int index = fromIdx; index < end; ++index) {
            char current;
            char currentCode = current = sequence.charAt(index);
            if (((Boolean)stopPredicate.invoke((Object)Character.valueOf(current), (Object)currentCode)).booleanValue()) break;
            Node<T> node2 = node.getArray()[currentCode];
            if (node2 == null) {
                if ((lowerCase ? node.getArray()[Character.toLowerCase(current)] : (node2 = null)) == null) {
                    return CollectionsKt.emptyList();
                }
            }
            Node<T> nextNode = node2;
            node = nextNode;
        }
        return node.getExact();
    }

    public static /* synthetic */ List search$default(AsciiCharTree asciiCharTree, CharSequence charSequence, int n, int n2, boolean bl, Function2 function2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return asciiCharTree.search(charSequence, n, n2, bl, (Function2<Character, Integer, Boolean>)function2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\bJR\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000b0\n2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\rJr\u0010\u0003\u001a\u00020\u000f\"\b\b\u0001\u0010\u0005*\u00020\u00012\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u00120\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000b0\n2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006\u0015"}, d2={"Lio/ktor/http/cio/internals/AsciiCharTree$Companion;", "", "()V", "build", "Lio/ktor/http/cio/internals/AsciiCharTree;", "T", "", "from", "", "length", "Lkotlin/Function1;", "", "charAt", "Lkotlin/Function2;", "", "", "resultList", "", "Lio/ktor/http/cio/internals/AsciiCharTree$Node;", "maxLength", "idx", "ktor-http-cio"})
    @SourceDebugExtension(value={"SMAP\nAsciiCharTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsciiCharTree.kt\nio/ktor/http/cio/internals/AsciiCharTree$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,73:1\n1963#2,14:74\n1747#2,3:88\n1477#2:91\n1502#2,3:92\n1505#2,3:102\n766#2:106\n857#2,2:107\n766#2:109\n857#2,2:110\n361#3,7:95\n215#4:105\n216#4:112\n*S KotlinDebug\n*F\n+ 1 AsciiCharTree.kt\nio/ktor/http/cio/internals/AsciiCharTree$Companion\n*L\n44#1:74,14\n47#1:88,3\n63#1:91\n63#1:92,3\n63#1:102,3\n66#1:106\n66#1:107,2\n68#1:109\n68#1:110,2\n63#1:95,7\n63#1:105\n63#1:112\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends CharSequence> AsciiCharTree<T> build(@NotNull List<? extends T> from) {
            Intrinsics.checkNotNullParameter(from, (String)"from");
            return this.build(from, build.1.INSTANCE, build.2.INSTANCE);
        }

        @NotNull
        public final <T> AsciiCharTree<T> build(@NotNull List<? extends T> from, @NotNull Function1<? super T, Integer> length, @NotNull Function2<? super T, ? super Integer, Character> charAt) {
            boolean bl;
            int maxLen;
            block10: {
                Object v0;
                Intrinsics.checkNotNullParameter(from, (String)"from");
                Intrinsics.checkNotNullParameter(length, (String)"length");
                Intrinsics.checkNotNullParameter(charAt, (String)"charAt");
                Iterable $this$maxByOrNull$iv = from;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = maxElem$iv;
                    } else {
                        Comparable maxValue$iv = (Comparable)length.invoke(maxElem$iv);
                        do {
                            Object e$iv;
                            Comparable v$iv;
                            if (maxValue$iv.compareTo(v$iv = (Comparable)length.invoke(e$iv = iterator$iv.next())) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = maxElem$iv;
                    }
                }
                if (v0 == null) {
                    throw new NoSuchElementException("Unable to build char tree from an empty list");
                }
                maxLen = ((Number)length.invoke(v0)).intValue();
                Iterable $this$any$iv = from;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv;
                        Object it = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!(((Number)length.invoke(it)).intValue() == 0)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new IllegalArgumentException("There should be no empty entries");
            }
            ArrayList root = new ArrayList();
            this.build(root, from, maxLen, 0, length, charAt);
            root.trimToSize();
            return new AsciiCharTree(new Node('\u0000', CollectionsKt.emptyList(), root));
        }

        /*
         * WARNING - void declaration
         */
        private final <T> void build(List<Node<T>> resultList, List<? extends T> from, int maxLength, int idx, Function1<? super T, Integer> length, Function2<? super T, ? super Integer, Character> charAt) {
            void $this$forEach$iv;
            List list$iv$iv;
            Object $this$getOrPut$iv$iv$iv;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv = from;
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object2;
                Object element$iv$iv;
                Object it = element$iv$iv = iterator.next();
                boolean bl = false;
                Character key$iv$iv = Character.valueOf(((Character)charAt.invoke(it, (Object)idx)).charValue());
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Object it;
                Object element$iv$iv;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                char ch = ((Character)entry.getKey()).charValue();
                List list = (List)entry.getValue();
                int nextIdx = idx + 1;
                ArrayList children = new ArrayList();
                $this$getOrPut$iv$iv$iv = list;
                List list2 = children;
                Object object3 = Companion;
                boolean $i$f$filter = false;
                list$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    it = element$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    if (!(((Number)length.invoke(it)).intValue() > nextIdx)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List list3 = (List)destination$iv$iv2;
                ((Companion)object3).build(list2, list3, maxLength, nextIdx, length, charAt);
                children.trimToSize();
                $this$filter$iv = list;
                char c = ch;
                object3 = resultList;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                $i$f$filterTo = false;
                iterator2 = $this$filterTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    it = element$iv$iv = iterator2.next();
                    boolean bl4 = false;
                    if (!(((Number)length.invoke(it)).intValue() == nextIdx)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List list4 = (List)destination$iv$iv2;
                List list5 = children;
                List list6 = list4;
                char c2 = c;
                object3.add(new Node(c2, list6, list5));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\t\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\u0006\u00a2\u0006\u0002\u0010\bR!\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00000\n\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lio/ktor/http/cio/internals/AsciiCharTree$Node;", "T", "", "ch", "", "exact", "", "children", "(CLjava/util/List;Ljava/util/List;)V", "array", "", "getArray", "()[Lio/ktor/http/cio/internals/AsciiCharTree$Node;", "[Lio/ktor/http/cio/internals/AsciiCharTree$Node;", "getCh", "()C", "getChildren", "()Ljava/util/List;", "getExact", "ktor-http-cio"})
    @SourceDebugExtension(value={"SMAP\nAsciiCharTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsciiCharTree.kt\nio/ktor/http/cio/internals/AsciiCharTree$Node\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n661#2,11:74\n*S KotlinDebug\n*F\n+ 1 AsciiCharTree.kt\nio/ktor/http/cio/internals/AsciiCharTree$Node\n*L\n9#1:74,11\n*E\n"})
    public static final class Node<T> {
        private final char ch;
        @NotNull
        private final List<T> exact;
        @NotNull
        private final List<Node<T>> children;
        @NotNull
        private final Node<T>[] array;

        /*
         * WARNING - void declaration
         */
        public Node(char ch, @NotNull List<? extends T> exact2, @NotNull List<Node<T>> children) {
            Intrinsics.checkNotNullParameter(exact2, (String)"exact");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.ch = ch;
            this.exact = exact2;
            this.children = children;
            Node[] nodeArray = new Node[256];
            Node node = this;
            for (char c = '\u0000'; c < '\u0100'; ++c) {
                Object v0;
                block3: {
                    void $this$singleOrNull$iv;
                    char c2 = c;
                    Iterable iterable = this.children;
                    char c3 = c2;
                    Node[] nodeArray2 = nodeArray;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        Node it = (Node)element$iv;
                        boolean bl = false;
                        if (!(it.ch == c2)) continue;
                        if (found$iv) {
                            v0 = null;
                            break block3;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v0 = !found$iv ? null : single$iv;
                }
                Object var18_18 = v0;
                nodeArray2[c3] = var18_18;
            }
            node.array = nodeArray;
        }

        public final char getCh() {
            return this.ch;
        }

        @NotNull
        public final List<T> getExact() {
            return this.exact;
        }

        @NotNull
        public final List<Node<T>> getChildren() {
            return this.children;
        }

        @NotNull
        public final Node<T>[] getArray() {
            return this.array;
        }
    }
}

