/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.serviceView.ConfigureServicesDialogKt;
import com.intellij.platform.execution.serviceView.RootNode;
import com.intellij.platform.execution.serviceView.RunConfigurationTypeNode;
import com.intellij.platform.execution.serviceView.RunDashboardNode;
import com.intellij.platform.execution.serviceView.ServiceTreeNode;
import com.intellij.platform.execution.serviceView.ServiceViewContributorNode;
import com.intellij.platform.execution.serviceView.ServicesTreeRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001c\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016J.\u0010\u0017\u001a\u00020\u00142\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010\u001f\u001a\u00020\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0019J\u0014\u0010\"\u001a\u00020\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0019J\b\u0010#\u001a\u00020\u0014H\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%J\u0014\u0010&\u001a\u00020\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0019J\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006*"}, d2={"Lcom/intellij/platform/execution/serviceView/ServicesTree;", "", "project", "Lcom/intellij/openapi/project/Project;", "runDashboardNodeName", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "root", "Lcom/intellij/platform/execution/serviceView/RootNode;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "runDashboardNode", "Lcom/intellij/platform/execution/serviceView/RunDashboardNode;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "getTree", "()Lcom/intellij/ui/treeStructure/Tree;", "installDoubleClickListener", "", "action", "Lkotlin/Function0;", "initTree", "services", "", "Lcom/intellij/execution/services/ServiceViewContributor;", "types", "Lcom/intellij/execution/configurations/ConfigurationType;", "expandTypes", "", "addNodes", "nodes", "Lcom/intellij/platform/execution/serviceView/ServiceTreeNode;", "removeNodes", "updateModel", "getSelectedNodes", "", "selectNodes", "getServices", "getTypes", "", "intellij.platform.execution.serviceView"})
@SourceDebugExtension(value={"SMAP\nConfigureServicesDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureServicesDialog.kt\ncom/intellij/platform/execution/serviceView/ServicesTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,338:1\n1557#2:339\n1628#2,3:340\n808#2,11:344\n808#2,11:355\n808#2,11:379\n1557#2:390\n1628#2,3:391\n1#3:343\n1#3:376\n11483#4,9:366\n13409#4:375\n13410#4:377\n11492#4:378\n37#5,2:394\n*S KotlinDebug\n*F\n+ 1 ConfigureServicesDialog.kt\ncom/intellij/platform/execution/serviceView/ServicesTree\n*L\n206#1:339\n206#1:340,3\n214#1:344,11\n226#1:355,11\n270#1:379,11\n274#1:390\n274#1:391,3\n269#1:376\n269#1:366,9\n269#1:375\n269#1:377\n269#1:378\n275#1:394,2\n*E\n"})
final class ServicesTree {
    @NotNull
    private final Project project;
    @NotNull
    private final String runDashboardNodeName;
    @NotNull
    private final RootNode root;
    @NotNull
    private final DefaultTreeModel model;
    @Nullable
    private RunDashboardNode runDashboardNode;
    @NotNull
    private final Tree tree;

    public ServicesTree(@NotNull Project project, @NotNull String runDashboardNodeName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runDashboardNodeName, (String)"runDashboardNodeName");
        this.project = project;
        this.runDashboardNodeName = runDashboardNodeName;
        this.root = new RootNode();
        this.model = new DefaultTreeModel(this.root);
        this.tree = new Tree((TreeModel)this.model);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        TreeSpeedSearch.installOn((JTree)((JTree)this.tree), (boolean)true, arg_0 -> ServicesTree._init_$lambda$1(ServicesTree::_init_$lambda$0, arg_0));
        this.tree.setCellRenderer((TreeCellRenderer)((Object)new ServicesTreeRenderer()));
    }

    @NotNull
    public final Tree getTree() {
        return this.tree;
    }

    public final void installDoubleClickListener(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        new DoubleClickListener(this, action){
            final /* synthetic */ ServicesTree this$0;
            final /* synthetic */ Function0<Unit> $action;
            {
                this.this$0 = $receiver;
                this.$action = $action;
            }

            protected boolean onDoubleClick(MouseEvent event) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TreePath[] treePathArray = this.this$0.getTree().getSelectionPaths();
                if (treePathArray != null) {
                    boolean bl2;
                    block4: {
                        TreePath[] $this$all$iv = treePathArray;
                        boolean $i$f$all = false;
                        int n = $this$all$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TreePath element$iv;
                            TreePath it = element$iv = $this$all$iv[i];
                            boolean bl3 = false;
                            TreePath treePath = it;
                            Object object = treePath != null ? treePath.getLastPathComponent() : null;
                            ServiceTreeNode serviceTreeNode = object instanceof ServiceTreeNode ? (ServiceTreeNode)object : null;
                            if (serviceTreeNode != null ? serviceTreeNode.isLeaf() : false) continue;
                            bl2 = false;
                            break block4;
                        }
                        bl2 = true;
                    }
                    bl = bl2;
                } else {
                    bl = false;
                }
                if (bl) {
                    this.$action.invoke();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.tree);
    }

    public final void initTree(@NotNull Collection<? extends ServiceViewContributor<?>> services, @NotNull Collection<? extends ConfigurationType> types, boolean expandTypes) {
        Collection<RunConfigurationTypeNode> collection;
        ConfigurationType it;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Iterable iterable = services;
        ServicesTree servicesTree = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ServiceViewContributor serviceViewContributor = (ServiceViewContributor)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new ServiceViewContributorNode((ServiceViewContributor<?>)it, this.project));
        }
        $this$map$iv = types;
        collection2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ConfigurationType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new RunConfigurationTypeNode(it));
        }
        collection = (List)destination$iv$iv;
        servicesTree.addNodes(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        if (expandTypes && this.runDashboardNode != null) {
            RunDashboardNode runDashboardNode = this.runDashboardNode;
            Intrinsics.checkNotNull((Object)runDashboardNode);
            this.tree.expandPath(TreeUtil.getPathFromRoot((TreeNode)runDashboardNode));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addNodes(@NotNull Collection<? extends ServiceTreeNode> nodes) {
        void $this$filterIsInstanceTo$iv$iv;
        Object types;
        Object object;
        Object object2;
        block13: {
            void $this$filterIsInstanceTo$iv$iv2;
            block12: {
                ServiceTreeNode typesNode;
                Object v0;
                block11: {
                    Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                    object2 = nodes;
                    Iterator<Object> iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        ServiceTreeNode it = (ServiceTreeNode)t;
                        boolean bl = false;
                        if (!(it instanceof RunDashboardNode)) continue;
                        v0 = t;
                        break block11;
                    }
                    v0 = null;
                }
                if ((object = (typesNode = (ServiceTreeNode)v0)) == null || (object = ((DefaultMutableTreeNode)object).children()) == null) break block12;
                ArrayList arrayList = Collections.list(object);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                object = arrayList;
                if (object != null) break block13;
            }
            Iterable $this$filterIsInstance$iv = nodes;
            boolean $i$f$filterIsInstance2 = false;
            Iterable bl = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof RunConfigurationTypeNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = (List)destination$iv$iv;
        }
        if (!((Collection)(types = object)).isEmpty()) {
            if (this.runDashboardNode == null) {
                this.runDashboardNode = new RunDashboardNode(this.runDashboardNodeName);
                this.root.add(this.runDashboardNode);
            }
            object2 = types.iterator();
            while (object2.hasNext()) {
                TreeNode type = (TreeNode)object2.next();
                RunDashboardNode runDashboardNode = this.runDashboardNode;
                Intrinsics.checkNotNull((Object)runDashboardNode);
                Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type javax.swing.tree.MutableTreeNode");
                runDashboardNode.add((MutableTreeNode)type);
            }
            RunDashboardNode runDashboardNode = this.runDashboardNode;
            Intrinsics.checkNotNull((Object)runDashboardNode);
            TreeUtil.sort((DefaultMutableTreeNode)runDashboardNode, (Comparator)ConfigureServicesDialogKt.access$getNodeComparator$p());
        }
        Iterable $this$filterIsInstance$iv = nodes;
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$filterIsInstance2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ServiceViewContributorNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List services = (List)destination$iv$iv;
        if (!((Collection)services).isEmpty()) {
            for (ServiceViewContributorNode service : services) {
                this.root.add(service);
            }
            TreeUtil.sort((DefaultMutableTreeNode)this.root, (Comparator)ConfigureServicesDialogKt.access$getNodeComparator$p());
        }
        this.updateModel();
    }

    public final void removeNodes(@NotNull Collection<? extends ServiceTreeNode> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        for (ServiceTreeNode serviceTreeNode : nodes) {
            ServiceTreeNode serviceTreeNode2 = serviceTreeNode;
            if (serviceTreeNode2 instanceof ServiceViewContributorNode) {
                this.root.remove(serviceTreeNode);
                continue;
            }
            if (serviceTreeNode2 instanceof RunDashboardNode) {
                this.root.remove(serviceTreeNode);
                this.runDashboardNode = null;
                continue;
            }
            if (!(serviceTreeNode2 instanceof RunConfigurationTypeNode)) continue;
            RunDashboardNode runDashboardNode = this.runDashboardNode;
            if (runDashboardNode == null) continue;
            runDashboardNode.remove(serviceTreeNode);
        }
        this.updateModel();
    }

    private final void updateModel() {
        boolean bl;
        RunDashboardNode runDashboardNode = this.runDashboardNode;
        if (runDashboardNode != null) {
            RunDashboardNode it = runDashboardNode;
            boolean bl2 = false;
            RunDashboardNode runDashboardNode2 = this.runDashboardNode;
            Intrinsics.checkNotNull((Object)runDashboardNode2);
            bl = this.tree.isExpanded(TreeUtil.getPathFromRoot((TreeNode)runDashboardNode2));
        } else {
            bl = false;
        }
        boolean expanded = bl;
        this.model.nodeStructureChanged(this.root);
        if (this.runDashboardNode != null) {
            this.model.nodeStructureChanged(this.runDashboardNode);
            if (expanded) {
                RunDashboardNode runDashboardNode3 = this.runDashboardNode;
                Intrinsics.checkNotNull((Object)runDashboardNode3);
                this.tree.expandPath(TreeUtil.getPathFromRoot((TreeNode)runDashboardNode3));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ServiceTreeNode> getSelectedNodes() {
        List list;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            TreePath[] $this$mapNotNull$iv = treePathArray;
            boolean $i$f$mapNotNull = false;
            TreePath[] treePathArray2 = $this$mapNotNull$iv;
            Iterable<Object> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Object it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (it.getLastPathComponent() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            destination$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ServiceTreeNode)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final void selectNodes(@NotNull Collection<? extends ServiceTreeNode> nodes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Iterable $this$map$iv = nodes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ServiceTreeNode serviceTreeNode = (ServiceTreeNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TreeUtil.getPathFromRoot((TreeNode)((TreeNode)it)));
        }
        List paths = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = paths;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.tree.getSelectionModel().setSelectionPaths(thisCollection$iv.toArray(new TreePath[0]));
        if (!((Collection)paths).isEmpty()) {
            TreeUtil.showRowCentered((JTree)((JTree)this.tree), (int)this.tree.getRowForPath((TreePath)CollectionsKt.first((List)paths)), (boolean)false, (boolean)true);
        }
    }

    @NotNull
    public final Collection<ServiceViewContributor<?>> getServices() {
        ArrayList services = new ArrayList();
        Enumeration<TreeNode> enumeration = this.root.children();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            TreeNode child = (TreeNode)iterator.next();
            if (!(child instanceof ServiceViewContributorNode)) continue;
            services.add(((ServiceViewContributorNode)child).getContributor());
        }
        return services;
    }

    @NotNull
    public final Set<String> getTypes() {
        if (this.runDashboardNode == null) {
            return SetsKt.emptySet();
        }
        HashSet<String> types = new HashSet<String>();
        RunDashboardNode runDashboardNode = this.runDashboardNode;
        Intrinsics.checkNotNull((Object)runDashboardNode);
        Enumeration<TreeNode> enumeration = runDashboardNode.children();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            TreeNode child = (TreeNode)iterator.next();
            Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type com.intellij.platform.execution.serviceView.RunConfigurationTypeNode");
            types.add(((RunConfigurationTypeNode)child).getType().getId());
        }
        return types;
    }

    private static final String _init_$lambda$0(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        Object object2 = object instanceof ServiceTreeNode ? (ServiceTreeNode)object : null;
        if (object2 == null || (object2 = ((ServiceTreeNode)object2).getText()) == null) {
            object2 = "";
        }
        return object2;
    }

    private static final String _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

