/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.dependency.analyzer;

import com.google.gson.GsonBuilder;
import com.intellij.gradle.toolingExtension.impl.model.dependencyGraphModel.GradleDependencyNodeDeserializer;
import com.intellij.gradle.toolingExtension.impl.model.dependencyGraphModel.GradleDependencyReportTask;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAArtifact;
import com.intellij.openapi.externalSystem.dependency.analyzer.DADependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAModule;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAProject;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAScope;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAWarning;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerContributor;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerProject;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ReferenceNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ResolutionState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleData;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001d\u001a\u00020\tH\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u001e\u001a\u00020\t2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J6\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&2\u0006\u0010'\u001a\u00020\u000bH\u0002J\"\u0010(\u001a\u0004\u0018\u00010\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0010H\u0002J\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\f*\u00020$2\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010-\u001a\u0004\u0018\u00010,*\u00020$H\u0002J\u000e\u0010.\u001a\u0004\u0018\u00010/*\u000200H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/gradle/dependency/analyzer/GradleDependencyAnalyzerContributor;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerContributor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "projects", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerProject;", "Lorg/jetbrains/plugins/gradle/util/GradleModuleData;", "configurationNodesMap", "", "", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/DependencyScopeNode;", "dependencyMap", "", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;", "whenDataChanged", "", "listener", "Lkotlin/Function0;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getProjects", "getDependencyScopes", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Scope;", "externalProject", "getDependencies", "getOrRefreshData", "gradleModuleData", "moduleData", "scopeNodes", "addDependencies", "usage", "scope", "dependencyNode", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/DependencyNode;", "dependencies", "", "gradleProjectDir", "createDependency", "getStatus", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Status;", "data", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "getDependencyData", "getModuleData", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/ProjectDependencyNode;", "Companion", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleDependencyAnalyzerContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDependencyAnalyzerContributor.kt\norg/jetbrains/plugins/gradle/dependency/analyzer/GradleDependencyAnalyzerContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1557#2:218\n1628#2,3:219\n1#3:222\n*S KotlinDebug\n*F\n+ 1 GradleDependencyAnalyzerContributor.kt\norg/jetbrains/plugins/gradle/dependency/analyzer/GradleDependencyAnalyzerContributor\n*L\n78#1:218\n78#1:219,3\n*E\n"})
public final class GradleDependencyAnalyzerContributor
implements DependencyAnalyzerContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<DependencyAnalyzerProject, GradleModuleData> projects;
    @NotNull
    private final ConcurrentHashMap<String, List<DependencyScopeNode>> configurationNodesMap;
    @NotNull
    private final ConcurrentHashMap<Long, DependencyAnalyzerDependency> dependencyMap;
    @NotNull
    private static final DAScope defaultConfiguration = org.jetbrains.plugins.gradle.dependency.analyzer.GradleDependencyAnalyzerContributor$Companion.access$scope(Companion, "default");
    @NotNull
    private static final com.intellij.openapi.util.Key<ModuleData> MODULE_DATA;

    public GradleDependencyAnalyzerContributor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.projects = new ConcurrentHashMap();
        this.configurationNodesMap = new ConcurrentHashMap();
        this.dependencyMap = new ConcurrentHashMap();
    }

    public void whenDataChanged(@NotNull Function0<Unit> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        progressManager.addNotificationListener(new ExternalSystemTaskNotificationListener(this, listener2){
            final /* synthetic */ GradleDependencyAnalyzerContributor this$0;
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.this$0 = $receiver;
                this.$listener = $listener;
            }

            public void onEnd(ExternalSystemTaskId id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                if (id.getType() != ExternalSystemTaskType.RESOLVE_PROJECT) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)id.getProjectSystemId(), (Object)GradleConstants.SYSTEM_ID)) {
                    return;
                }
                GradleDependencyAnalyzerContributor.access$getProjects$p(this.this$0).clear();
                GradleDependencyAnalyzerContributor.access$getConfigurationNodesMap$p(this.this$0).clear();
                GradleDependencyAnalyzerContributor.access$getDependencyMap$p(this.this$0).clear();
                this.$listener.invoke();
            }
        }, parentDisposable);
    }

    @NotNull
    public List<DependencyAnalyzerProject> getProjects() {
        if (this.projects.isEmpty()) {
            ProjectDataManager projectDataManager = ProjectDataManager.getInstance();
            for (ExternalProjectInfo projectInfo : projectDataManager.getExternalProjectsData(this.project, GradleConstants.SYSTEM_ID)) {
                DataNode projectStructure;
                if (projectInfo.getExternalProjectStructure() == null) continue;
                for (DataNode moduleNode : ExternalSystemApiUtil.findAll((DataNode)projectStructure, (Key)ProjectKeys.MODULE)) {
                    Module module;
                    Object object = moduleNode.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
                    ModuleData moduleData = (ModuleData)object;
                    Intrinsics.checkNotNull((Object)moduleNode);
                    GradleModuleData gradleModuleData = new GradleModuleData((DataNode<? extends ModuleData>)moduleNode);
                    if (gradleModuleData.isBuildSrcModule() || GradleUtil.findGradleModule(this.project, moduleData) == null) continue;
                    String string = moduleData.getModuleName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getModuleName(...)");
                    DAProject externalProject = new DAProject(module, string);
                    ((Map)this.projects).put(externalProject, gradleModuleData);
                }
            }
        }
        Set set = this.projects.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return CollectionsKt.toList((Iterable)set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DependencyAnalyzerDependency.Scope> getDependencyScopes(@NotNull DependencyAnalyzerProject externalProject) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        GradleModuleData gradleModuleData = this.projects.get(externalProject);
        if (gradleModuleData == null) {
            return CollectionsKt.emptyList();
        }
        GradleModuleData gradleModuleData2 = gradleModuleData;
        Iterable $this$map$iv = this.getOrRefreshData(gradleModuleData2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DependencyScopeNode dependencyScopeNode = (DependencyScopeNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GradleDependencyAnalyzerContributor.Companion.toScope((DependencyScopeNode)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<DependencyAnalyzerDependency> getDependencies(@NotNull DependencyAnalyzerProject externalProject) {
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        GradleModuleData gradleModuleData = this.projects.get(externalProject);
        if (gradleModuleData == null) {
            return CollectionsKt.emptyList();
        }
        GradleModuleData gradleModuleData2 = gradleModuleData;
        List<DependencyScopeNode> scopeNodes = this.getOrRefreshData(gradleModuleData2);
        return this.getDependencies(gradleModuleData2, scopeNodes);
    }

    private final List<DependencyScopeNode> getOrRefreshData(GradleModuleData gradleModuleData) {
        List list = this.configurationNodesMap.computeIfAbsent(gradleModuleData.getGradleProjectDir(), arg_0 -> GradleDependencyAnalyzerContributor.getOrRefreshData$lambda$2(arg_0 -> GradleDependencyAnalyzerContributor.getOrRefreshData$lambda$1(gradleModuleData, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"computeIfAbsent(...)");
        return list;
    }

    private final List<DependencyAnalyzerDependency> getDependencies(GradleModuleData moduleData, List<? extends DependencyScopeNode> scopeNodes) {
        if (scopeNodes.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<DADependency> dependencies = new ArrayList<DADependency>();
        DAModule root = new DAModule(moduleData.getModuleName());
        root.putUserData(MODULE_DATA, (Object)moduleData.getModuleData());
        DADependency rootDependency = new DADependency((DependencyAnalyzerDependency.Data)root, (DependencyAnalyzerDependency.Scope)defaultConfiguration, null, CollectionsKt.emptyList());
        dependencies.add(rootDependency);
        for (DependencyScopeNode dependencyScopeNode : scopeNodes) {
            DAScope scope = GradleDependencyAnalyzerContributor.Companion.toScope(dependencyScopeNode);
            for (DependencyNode dependencyNode : dependencyScopeNode.getDependencies()) {
                DependencyAnalyzerDependency dependencyAnalyzerDependency = (DependencyAnalyzerDependency)rootDependency;
                DependencyAnalyzerDependency.Scope scope2 = (DependencyAnalyzerDependency.Scope)scope;
                Intrinsics.checkNotNull((Object)dependencyNode);
                this.addDependencies(dependencyAnalyzerDependency, scope2, dependencyNode, (List<DependencyAnalyzerDependency>)dependencies, moduleData.getGradleProjectDir());
            }
        }
        return dependencies;
    }

    private final void addDependencies(DependencyAnalyzerDependency usage, DependencyAnalyzerDependency.Scope scope, DependencyNode dependencyNode, List<DependencyAnalyzerDependency> dependencies, String gradleProjectDir) {
        DependencyAnalyzerDependency dependencyAnalyzerDependency = this.createDependency(dependencyNode, scope, usage);
        if (dependencyAnalyzerDependency == null) {
            return;
        }
        DependencyAnalyzerDependency dependency = dependencyAnalyzerDependency;
        dependencies.add(dependency);
        for (DependencyNode node : dependencyNode.getDependencies()) {
            Intrinsics.checkNotNull((Object)node);
            this.addDependencies(dependency, scope, node, dependencies, gradleProjectDir);
        }
    }

    private final DependencyAnalyzerDependency createDependency(DependencyNode dependencyNode, DependencyAnalyzerDependency.Scope scope, DependencyAnalyzerDependency usage) {
        DADependency dADependency;
        if (dependencyNode instanceof ReferenceNode) {
            DependencyAnalyzerDependency dependencyAnalyzerDependency = this.dependencyMap.get(((ReferenceNode)dependencyNode).getId());
            if (dependencyAnalyzerDependency == null) {
                return null;
            }
            DependencyAnalyzerDependency dependency = dependencyAnalyzerDependency;
            return (DependencyAnalyzerDependency)new DADependency(dependency.getData(), scope, usage, dependency.getStatus());
        }
        DependencyAnalyzerDependency.Data data = this.getDependencyData(dependencyNode);
        if (data == null) {
            return null;
        }
        DependencyAnalyzerDependency.Data dependencyData = data;
        List<DependencyAnalyzerDependency.Status> status = this.getStatus(dependencyNode, dependencyData);
        DADependency it = dADependency = new DADependency(dependencyData, scope, usage, status);
        boolean bl = false;
        ((Map)this.dependencyMap).put(dependencyNode.getId(), it);
        return (DependencyAnalyzerDependency)dADependency;
    }

    private final List<DependencyAnalyzerDependency.Status> getStatus(DependencyNode $this$getStatus, DependencyAnalyzerDependency.Data data) {
        String conflictedVersion;
        List status = new ArrayList();
        if ($this$getStatus.getResolutionState() == ResolutionState.UNRESOLVED) {
            String message = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.unresolved", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)message);
            status.add(new DAWarning(message));
        }
        String selectionReason = $this$getStatus.getSelectionReason();
        if (data instanceof DependencyAnalyzerDependency.Data.Artifact && selectionReason != null && StringsKt.startsWith$default((String)selectionReason, (String)"between versions", (boolean)false, (int)2, null) && ((CharSequence)(conflictedVersion = StringsKt.substringAfter((String)selectionReason, (String)("between versions " + ((DependencyAnalyzerDependency.Data.Artifact)data).getVersion() + " and "), (String)""))).length() > 0) {
            Object[] objectArray = new Object[]{conflictedVersion};
            String message = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.version.conflict", (Object[])objectArray);
            Intrinsics.checkNotNull((Object)message);
            status.add(new DAWarning(message));
        }
        return status;
    }

    /*
     * WARNING - void declaration
     */
    private final DependencyAnalyzerDependency.Data getDependencyData(DependencyNode $this$getDependencyData) {
        DependencyAnalyzerDependency.Data data;
        DependencyNode dependencyNode = $this$getDependencyData;
        if (dependencyNode instanceof ProjectDependencyNode) {
            void var3_4;
            String string = ((ProjectDependencyNode)$this$getDependencyData).getProjectName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProjectName(...)");
            DAModule data2 = new DAModule(string);
            ModuleData moduleData = this.getModuleData((ProjectDependencyNode)$this$getDependencyData);
            data2.putUserData(MODULE_DATA, (Object)moduleData);
            data = (DependencyAnalyzerDependency.Data)var3_4;
        } else if (dependencyNode instanceof ArtifactDependencyNode) {
            String string = ((ArtifactDependencyNode)$this$getDependencyData).getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroup(...)");
            String string2 = ((ArtifactDependencyNode)$this$getDependencyData).getModule();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getModule(...)");
            String string3 = ((ArtifactDependencyNode)$this$getDependencyData).getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
            data = (DependencyAnalyzerDependency.Data)new DAArtifact(string, string2, string3);
        } else {
            data = null;
        }
        return data;
    }

    private final ModuleData getModuleData(ProjectDependencyNode $this$getModuleData) {
        Object v1;
        block1: {
            Collection<GradleModuleData> collection = this.projects.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), GradleDependencyAnalyzerContributor::getModuleData$lambda$4);
            for (Object e : sequence) {
                ModuleData it = (ModuleData)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)$this$getModuleData.getProjectPath())) continue;
                v1 = e;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final List getOrRefreshData$lambda$1(GradleModuleData $gradleModuleData, GradleDependencyAnalyzerContributor this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GradleDependencyAnalyzerContributor.Companion.loadDependencies($gradleModuleData, this$0.project);
    }

    private static final List getOrRefreshData$lambda$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final ModuleData getModuleData$lambda$4(GradleModuleData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getModuleData();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getProjects$p(GradleDependencyAnalyzerContributor $this) {
        return $this.projects;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getConfigurationNodesMap$p(GradleDependencyAnalyzerContributor $this) {
        return $this.configurationNodesMap;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getDependencyMap$p(GradleDependencyAnalyzerContributor $this) {
        return $this.dependencyMap;
    }

    static {
        com.intellij.openapi.util.Key key = com.intellij.openapi.util.Key.create((String)"GradleDependencyAnalyzerContributor.ModuleData");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MODULE_DATA = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0005*\u00020\u0011H\u0002J\u0015\u0010\u0016\u001a\u00020\u00052\u000b\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0019H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R'\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gradle/dependency/analyzer/GradleDependencyAnalyzerContributor$Companion;", "", "<init>", "()V", "defaultConfiguration", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DAScope;", "getDefaultConfiguration$intellij_gradle", "()Lcom/intellij/openapi/externalSystem/dependency/analyzer/DAScope;", "MODULE_DATA", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getMODULE_DATA$intellij_gradle", "()Lcom/intellij/openapi/util/Key;", "loadDependencies", "", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/DependencyScopeNode;", "Lorg/jetbrains/plugins/gradle/util/GradleModuleData;", "project", "Lcom/intellij/openapi/project/Project;", "toScope", "scope", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DAScope getDefaultConfiguration$intellij_gradle() {
            return defaultConfiguration;
        }

        @NotNull
        public final com.intellij.openapi.util.Key<ModuleData> getMODULE_DATA$intellij_gradle() {
            return MODULE_DATA;
        }

        private final List<DependencyScopeNode> loadDependencies(GradleModuleData $this$loadDependencies, Project project2) {
            Ref.ObjectRef dependencyScopeNodes = new Ref.ObjectRef();
            dependencyScopeNodes.element = CollectionsKt.emptyList();
            File file = FileUtil.createTempFile((String)"dependencies", (String)".json", (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            File outputFile = file;
            String taskConfiguration = StringsKt.trimIndent((String)("\n        outputFile = project.file(\"" + FileUtil.toCanonicalPath((String)outputFile.getAbsolutePath()) + "\")\n        configurations = []\n        "));
            GradleTaskManager.runCustomTask(project2, GradleBundle.message("gradle.dependency.analyzer.loading", new Object[0]), GradleDependencyReportTask.class, $this$loadDependencies.getDirectoryToRunTask(), $this$loadDependencies.getFullGradlePath(), taskConfiguration, ProgressExecutionMode.NO_PROGRESS_SYNC, new TaskCallback(outputFile, (Ref.ObjectRef<List<DependencyScopeNode>>)dependencyScopeNodes){
                final /* synthetic */ File $outputFile;
                final /* synthetic */ Ref.ObjectRef<List<DependencyScopeNode>> $dependencyScopeNodes;
                {
                    this.$outputFile = $outputFile;
                    this.$dependencyScopeNodes = $dependencyScopeNodes;
                }

                public void onSuccess() {
                    Object[] scopeNodes;
                    String string = FileUtil.loadFile((File)this.$outputFile);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
                    String json = string;
                    GsonBuilder gsonBuilder = new GsonBuilder();
                    gsonBuilder.registerTypeAdapter((Type)((Object)DependencyNode.class), (Object)new GradleDependencyNodeDeserializer());
                    Object object = scopeNodes = (DependencyScopeNode[])gsonBuilder.create().fromJson(json, DependencyScopeNode[].class);
                    if (scopeNodes == null || (object = ArraysKt.asList((Object[])object)) == null) {
                        object = CollectionsKt.emptyList();
                    }
                    this.$dependencyScopeNodes.element = object;
                }

                public void onFailure() {
                }
            });
            FileUtil.asyncDelete((File)outputFile);
            return (List)dependencyScopeNodes.element;
        }

        private final DAScope toScope(DependencyScopeNode $this$toScope) {
            String string = $this$toScope.getScope();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScope(...)");
            return this.scope(string);
        }

        private final DAScope scope(String name) {
            String string = StringUtil.toTitleCase((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toTitleCase(...)");
            return new DAScope(name, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ DAScope access$scope(Companion $this, String name) {
            return $this.scope(name);
        }
    }
}

