/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.documentation;

import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigFlatOptionKey;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigConstantDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigDeclarationDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigReferenceDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/editorconfig/language/codeinsight/documentation/EditorConfigElementDescriptionProvider;", "Lcom/intellij/psi/ElementDescriptionProvider;", "<init>", "()V", "getElementDescription", "", "element", "Lcom/intellij/psi/PsiElement;", "location", "Lcom/intellij/psi/ElementDescriptionLocation;", "intellij.editorconfig"})
public final class EditorConfigElementDescriptionProvider
implements ElementDescriptionProvider {
    @Nullable
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (!(element instanceof EditorConfigDescribableElement)) {
            return null;
        }
        if (element instanceof EditorConfigFlatOptionKey) {
            Object[] objectArray = new Object[]{((EditorConfigFlatOptionKey)element).getText(), ((EditorConfigFlatOptionKey)element).getSection().getHeader().getText()};
            return EditorConfigBundle.INSTANCE.get("usage.type.option.key", objectArray);
        }
        EditorConfigDescriptor editorConfigDescriptor = ((EditorConfigDescribableElement)element).getDescriptor(false);
        if (editorConfigDescriptor instanceof EditorConfigDeclarationDescriptor || editorConfigDescriptor instanceof EditorConfigReferenceDescriptor) {
            Object[] objectArray = new Object[]{((EditorConfigDescribableElement)element).getText(), ((EditorConfigDescribableElement)element).getSection().getHeader().getText()};
            string = EditorConfigBundle.INSTANCE.get("usage.type.identifier", objectArray);
        } else if (editorConfigDescriptor instanceof EditorConfigConstantDescriptor) {
            Object[] objectArray = new Object[]{((EditorConfigDescribableElement)element).getText(), ((EditorConfigDescribableElement)element).getSection().getHeader().getText()};
            string = EditorConfigBundle.INSTANCE.get("usage.type.constant", objectArray);
        } else {
            string = EditorConfigBundle.INSTANCE.get("usage.type.unknown");
        }
        return string;
    }
}

