/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.CharsetData;
import org.editorconfig.configmanagement.EditorConfigEncodingCache;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigEncodingInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "isHardcodedCharsetOrFailed", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getMainPsi", "psiFile", "ApplyEditorConfigEncodingQuickFix", "IgnoreFileQuickFix", "intellij.editorconfig"})
public final class EditorConfigEncodingInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!Intrinsics.areEqual((Object)file, (Object)this.getMainPsi(file))) {
            return null;
        }
        Project project = manager.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || !Utils.isEnabled(CodeStyle.getSettings((Project)project2)) || !virtualFile.isWritable()) {
            return null;
        }
        if (this.isHardcodedCharsetOrFailed(virtualFile)) {
            return null;
        }
        EditorConfigEncodingCache encodingCache = EditorConfigEncodingCache.Companion.getInstance();
        if (encodingCache.isIgnored(virtualFile)) {
            return null;
        }
        Project project3 = file.getProject();
        VirtualFile virtualFile2 = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        CharsetData charsetData = encodingCache.getCharsetData(project3, virtualFile2, false);
        if (charsetData == null) {
            return null;
        }
        CharsetData charsetData2 = charsetData;
        Charset charset = charsetData2.getCharset();
        if (charset != null && !Intrinsics.areEqual((Object)virtualFile.getCharset(), (Object)charset)) {
            ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[1];
            PsiElement psiElement = (PsiElement)file;
            String string = charset.displayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"displayName(...)");
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ApplyEditorConfigEncodingQuickFix(), new IgnoreFileQuickFix()};
            problemDescriptorArray[0] = manager.createProblemDescriptor(psiElement, EditorConfigBundle.message("inspection.file.encoding.mismatch.descriptor", string), localQuickFixArray, ProblemHighlightType.WARNING, isOnTheFly, false);
            return problemDescriptorArray;
        }
        return null;
    }

    private final boolean isHardcodedCharsetOrFailed(VirtualFile virtualFile) {
        boolean bl;
        FileType fileType = virtualFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        try {
            String charsetName = fileType2.getCharset(virtualFile, virtualFile.contentsToByteArray());
            bl = charsetName != null;
        }
        catch (IOException e) {
            bl = true;
        }
        return bl;
    }

    private final PsiFile getMainPsi(PsiFile psiFile) {
        Language language = psiFile.getViewProvider().getBaseLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getBaseLanguage(...)");
        Language baseLanguage = language;
        PsiFile psiFile2 = psiFile.getViewProvider().getPsi(baseLanguage);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getPsi(...)");
        return psiFile2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000b\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000e2\u000b\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigEncodingInspection$ApplyEditorConfigEncodingQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "showError", "title", "Lorg/jetbrains/annotations/Nls;", "message", "intellij.editorconfig"})
    private static final class ApplyEditorConfigEncodingQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return EditorConfigBundle.message("inspection.file.encoding.apply");
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            VirtualFile file = descriptor.getPsiElement().getContainingFile().getVirtualFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file);
            if (document != null) {
                EditorConfigEncodingCache editorConfigEncodingCache = EditorConfigEncodingCache.Companion.getInstance();
                Intrinsics.checkNotNull((Object)file);
                editorConfigEncodingCache.computeAndCacheEncoding(project, file);
                try {
                    LoadTextUtil.write((Project)project, (VirtualFile)file, (Object)file, (String)document.getText(), (long)document.getModificationStamp());
                }
                catch (IOException e) {
                    String string = EditorConfigBundle.message("inspection.file.encoding.save.error");
                    String string2 = e.getLocalizedMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocalizedMessage(...)");
                    this.showError(project, string, string2);
                }
            }
        }

        private final void showError(Project project, String title, String message) {
            NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup("editorconfig");
            Notifications.Bus.notify((Notification)group.createNotification(title, message, NotificationType.ERROR), (Project)project);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigEncodingInspection$IgnoreFileQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.editorconfig"})
    private static final class IgnoreFileQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return EditorConfigBundle.message("inspection.file.encoding.ignore");
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            VirtualFile file = descriptor.getPsiElement().getContainingFile().getVirtualFile();
            EditorConfigEncodingCache editorConfigEncodingCache = EditorConfigEncodingCache.Companion.getInstance();
            Intrinsics.checkNotNull((Object)file);
            editorConfigEncodingCache.setIgnored(file);
        }
    }
}

