/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.BlockTerminalView;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0012H\u0007J\u001a\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "terminalView", "Lorg/jetbrains/plugins/terminal/block/BlockTerminalView;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/block/BlockTerminalView;)V", "value", "", "isActive", "()Z", "setActive", "(Z)V", "listeners", "", "Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel$TerminalFocusListener;", "focusOutput", "", "focusPrompt", "addListener", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "requestFocus", "target", "Ljavax/swing/JComponent;", "TerminalFocusListener", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalFocusModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalFocusModel.kt\norg/jetbrains/plugins/terminal/block/TerminalFocusModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1863#2,2:97\n*S KotlinDebug\n*F\n+ 1 TerminalFocusModel.kt\norg/jetbrains/plugins/terminal/block/TerminalFocusModel\n*L\n29#1:97,2\n*E\n"})
public final class TerminalFocusModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final BlockTerminalView terminalView;
    private boolean isActive;
    @NotNull
    private final List<TerminalFocusListener> listeners;
    @NotNull
    private static final DataKey<TerminalFocusModel> KEY = DataKey.Companion.create("TerminalFocusModel");

    public TerminalFocusModel(@NotNull Project project, @NotNull BlockTerminalView terminalView) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)terminalView, (String)"terminalView");
        this.project = project;
        this.terminalView = terminalView;
        this.isActive = true;
        this.listeners = new CopyOnWriteArrayList();
        AWTEventListener listener2 = arg_0 -> TerminalFocusModel._init_$lambda$1(this, arg_0);
        Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 4L);
        Disposer.register((Disposable)this.terminalView, () -> TerminalFocusModel._init_$lambda$2(listener2));
        ActionsKt.invokeLater$default(null, () -> TerminalFocusModel._init_$lambda$3(this), (int)1, null);
    }

    public final boolean isActive() {
        return this.isActive;
    }

    private final void setActive(boolean value) {
        if (value != this.isActive) {
            this.isActive = value;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalFocusListener it = (TerminalFocusListener)element$iv;
                boolean bl = false;
                it.activeStateChanged(value);
            }
        }
    }

    @RequiresEdt
    public final void focusOutput() {
        this.requestFocus(this.terminalView.getOutputView().getPreferredFocusableComponent());
    }

    @RequiresEdt
    public final void focusPrompt() {
        this.requestFocus(this.terminalView.getPromptView().getPreferredFocusableComponent());
    }

    public final void addListener(@NotNull TerminalFocusListener listener2, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, () -> TerminalFocusModel.addListener$lambda$4(this, listener2));
        }
    }

    public static /* synthetic */ void addListener$default(TerminalFocusModel terminalFocusModel, TerminalFocusListener terminalFocusListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalFocusModel.addListener(terminalFocusListener, disposable);
    }

    private final void requestFocus(JComponent target) {
        if (!target.hasFocus()) {
            IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)target, true);
        }
    }

    private static final void _init_$lambda$1(TerminalFocusModel this$0, AWTEvent it) {
        if (UIUtil.isFocusAncestor((Component)this$0.terminalView.getComponent())) {
            this$0.setActive(true);
        } else {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            Intrinsics.checkNotNullExpressionValue((Object)menuElementArray, (String)"getSelectedPath(...)");
            Object object = ArraysKt.firstOrNull((Object[])menuElementArray);
            JPopupMenu menu = object instanceof JPopupMenu ? (JPopupMenu)object : null;
            this$0.setActive(UIUtil.isDescendingFrom((Component)menu, (Component)this$0.terminalView.getComponent()));
        }
    }

    private static final void _init_$lambda$2(AWTEventListener $listener) {
        Toolkit.getDefaultToolkit().removeAWTEventListener($listener);
    }

    private static final Unit _init_$lambda$3(TerminalFocusModel this$0) {
        this$0.terminalView.getPromptView().getPreferredFocusableComponent().addFocusListener(new FocusAdapter(this$0){
            final /* synthetic */ TerminalFocusModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusGained(FocusEvent e) {
                Iterable $this$forEach$iv = TerminalFocusModel.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TerminalFocusListener it = (TerminalFocusListener)element$iv;
                    boolean bl = false;
                    it.promptFocused();
                }
            }
        });
        return Unit.INSTANCE;
    }

    private static final void addListener$lambda$4(TerminalFocusModel this$0, TerminalFocusListener $listener) {
        this$0.listeners.remove($listener);
    }

    public static final /* synthetic */ List access$getListeners$p(TerminalFocusModel $this) {
        return $this.listeners;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalFocusModel> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/block/TerminalFocusModel$TerminalFocusListener;", "", "promptFocused", "", "activeStateChanged", "isActive", "", "intellij.terminal"})
    public static interface TerminalFocusListener {
        default public void promptFocused() {
        }

        default public void activeStateChanged(boolean isActive) {
        }
    }
}

