/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.ModificationAware;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.DescribedGradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ExternalToModelMap;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleDslElementImpl
implements GradleDslElement,
ModificationAware {
    @NotNull
    private static final String SINGLE_QUOTES = "'";
    @NotNull
    private static final String DOUBLE_QUOTES = "\"";
    @NotNull
    protected GradleNameElement myName;
    @Nullable
    protected GradleDslElement myParent;
    @NotNull
    protected List<GradlePropertiesDslElement> myHolders;
    @NotNull
    private final GradleDslFile myDslFile;
    @Nullable
    private PsiElement myPsiElement;
    @Nullable
    private GradleDslClosure myClosureElement;
    @Nullable
    private GradleDslClosure myUnsavedClosure;
    private long myLastCommittedModificationCount;
    private long myModificationCount;
    @NotNull
    protected ExternalNameInfo.ExternalNameSyntax mySyntax;
    @NotNull
    private PropertyType myElementType;
    @NotNull
    protected final List<GradleReferenceInjection> myDependencies;
    @NotNull
    protected final List<GradleReferenceInjection> myDependents;
    @Nullable
    private ModelEffectDescription myModelEffectDescription;

    protected GradleDslElementImpl(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name2) {
        if (name2 == null) {
            GradleDslElementImpl.$$$reportNull$$$0(0);
        }
        this.myHolders = new ArrayList<GradlePropertiesDslElement>();
        this.myDependencies = new ArrayList<GradleReferenceInjection>();
        this.myDependents = new ArrayList<GradleReferenceInjection>();
        assert (parent != null || this instanceof GradleDslFile);
        this.myParent = parent;
        this.myPsiElement = psiElement;
        this.myName = name2;
        this.myDslFile = parent == null ? (GradleDslFile)this : parent.getDslFile();
        this.mySyntax = ExternalNameInfo.ExternalNameSyntax.METHOD;
        this.myElementType = PropertyType.DERIVED;
    }

    @Override
    public void setParsedClosureElement(@NotNull GradleDslClosure closureElement) {
        if (closureElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(1);
        }
        this.myClosureElement = closureElement;
    }

    @Override
    public void setNewClosureElement(@Nullable GradleDslClosure closureElement) {
        this.myUnsavedClosure = closureElement;
        this.setModified();
    }

    @Override
    @Nullable
    public GradleDslClosure getUnsavedClosure() {
        return this.myUnsavedClosure;
    }

    @Override
    @Nullable
    public GradleDslClosure getClosureElement() {
        return this.myUnsavedClosure == null ? this.myClosureElement : this.myUnsavedClosure;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myModelEffectDescription == null ? this.myName.name() : this.myModelEffectDescription.property.name;
        if (string == null) {
            GradleDslElementImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        if (this.myParent == null || this.myParent instanceof GradleDslFile) {
            String string = GradleNameElement.escape(this.getName());
            if (string == null) {
                GradleDslElementImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        String ourName = this.getName();
        String string = this.myParent.getQualifiedName() + (String)(ourName.isEmpty() ? "" : "." + GradleNameElement.escape(ourName));
        if (string == null) {
            GradleDslElementImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFullName() {
        if (this.myModelEffectDescription == null) {
            String string = this.myName.fullName();
            if (string == null) {
                GradleDslElementImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        List<String> parts = this.myName.qualifyingParts();
        parts.add(this.getName());
        String string = GradleNameElement.createNameFromParts(parts);
        if (string == null) {
            GradleDslElementImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public GradleNameElement getNameElement() {
        GradleNameElement gradleNameElement = this.myName;
        if (gradleNameElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(7);
        }
        return gradleNameElement;
    }

    @Override
    public void setNameElement(@NotNull GradleNameElement name2) {
        if (name2 == null) {
            GradleDslElementImpl.$$$reportNull$$$0(8);
        }
        this.myName = name2;
    }

    @Override
    public void rename(@NotNull String newName) {
        if (newName == null) {
            GradleDslElementImpl.$$$reportNull$$$0(9);
        }
        this.rename(Arrays.asList(newName));
    }

    @Override
    public void rename(@NotNull List<String> hierarchicalName) {
        if (hierarchicalName == null) {
            GradleDslElementImpl.$$$reportNull$$$0(10);
        }
        this.myName.rename(hierarchicalName);
        this.setModified();
        if (!(this instanceof GradleDslSimpleExpression)) {
            return;
        }
        List<GradleReferenceInjection> dependents = this.getDependents();
        this.unregisterAllDependants();
        this.reorder();
        dependents.forEach(e -> e.getOriginElement().resolve());
        this.getDslFile().getContext().getDependencyManager().resolveWith(this);
    }

    @Override
    @Nullable
    public GradleDslElement getParent() {
        return this.myParent;
    }

    @Override
    public void setParent(@NotNull GradleDslElement parent) {
        if (parent == null) {
            GradleDslElementImpl.$$$reportNull$$$0(11);
        }
        this.myParent = parent;
    }

    @Override
    @NotNull
    public List<GradlePropertiesDslElement> getHolders() {
        List<GradlePropertiesDslElement> list = this.myHolders;
        if (list == null) {
            GradleDslElementImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    public void addHolder(@NotNull GradlePropertiesDslElement holder) {
        if (holder == null) {
            GradleDslElementImpl.$$$reportNull$$$0(13);
        }
        this.myHolders.add(holder);
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myPsiElement;
    }

    @Override
    public void setPsiElement(@Nullable PsiElement psiElement) {
        this.myPsiElement = psiElement;
    }

    @Override
    @NotNull
    public ExternalNameInfo.ExternalNameSyntax getExternalSyntax() {
        ExternalNameInfo.ExternalNameSyntax externalNameSyntax = this.mySyntax;
        if (externalNameSyntax == null) {
            GradleDslElementImpl.$$$reportNull$$$0(14);
        }
        return externalNameSyntax;
    }

    @Override
    public void setExternalSyntax(@NotNull ExternalNameInfo.ExternalNameSyntax syntax) {
        if (syntax == null) {
            GradleDslElementImpl.$$$reportNull$$$0(15);
        }
        this.mySyntax = syntax;
    }

    @Override
    @NotNull
    public PropertyType getElementType() {
        PropertyType propertyType = this.myElementType;
        if (propertyType == null) {
            GradleDslElementImpl.$$$reportNull$$$0(16);
        }
        return propertyType;
    }

    @Override
    public void setElementType(@NotNull PropertyType propertyType) {
        if (propertyType == null) {
            GradleDslElementImpl.$$$reportNull$$$0(17);
        }
        this.myElementType = propertyType;
    }

    @Override
    @NotNull
    public GradleDslFile getDslFile() {
        GradleDslFile gradleDslFile = this.myDslFile;
        if (gradleDslFile == null) {
            GradleDslElementImpl.$$$reportNull$$$0(18);
        }
        return gradleDslFile;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (GradleDslElement child : this.getChildren()) {
            resultBuilder.addAll(child.getResolvedVariables());
        }
        ImmutableList immutableList = resultBuilder.build();
        if (immutableList == null) {
            GradleDslElementImpl.$$$reportNull$$$0(19);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public GradleDslElement requestAnchor(@NotNull GradleDslElement element) {
        if (element == null) {
            GradleDslElementImpl.$$$reportNull$$$0(20);
        }
        return null;
    }

    @Override
    @Nullable
    public GradleDslElement getAnchor() {
        return this.myParent == null ? null : this.myParent.requestAnchor(this);
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.myDslFile.getWriter().createDslElement(this);
    }

    @Override
    @Nullable
    public PsiElement move() {
        return this.myDslFile.getWriter().moveDslElement(this);
    }

    @Override
    public void delete() {
        this.getDslFile().getWriter().deleteDslElement(this);
    }

    @Override
    public void setModified() {
        this.modify();
        if (this.myParent != null) {
            this.myParent.setModified();
            if (this instanceof DescribedGradlePropertiesDslElement && this.myParent instanceof GradlePropertiesDslElement) {
                ((GradlePropertiesDslElement)this.myParent).updateAppliedState(this);
            }
        }
    }

    @Override
    public boolean isModified() {
        return this.getLastCommittedModificationCount() != this.getModificationCount();
    }

    @Override
    public boolean isBlockElement() {
        return false;
    }

    @Override
    public boolean isInsignificantIfEmpty() {
        return true;
    }

    @Override
    @NotNull
    public abstract Collection<GradleDslElement> getChildren();

    @Override
    public final void applyChanges() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.apply();
        this.commit();
    }

    protected abstract void apply();

    @Override
    public final void resetState() {
        this.reset();
        this.commit();
    }

    protected abstract void reset();

    @Override
    @NotNull
    public List<GradleDslElement> getContainedElements(boolean includeProperties) {
        List<GradleDslElement> list = Collections.emptyList();
        if (list == null) {
            GradleDslElementImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Override
    @NotNull
    public Map<String, GradleDslElement> getInScopeElements() {
        GradleDslExpressionMap map;
        LinkedHashMap<String, GradleDslElement> results = new LinkedHashMap<String, GradleDslElement>();
        if (PropertyUtil.isNonExpressionPropertiesElement(this)) {
            GradlePropertiesDslElement thisElement = (GradlePropertiesDslElement)this;
            results.putAll(thisElement.getVariableElements());
        }
        GradleDslElement currentElement = this;
        while (currentElement != null && currentElement.getParent() != null) {
            if (!PropertyUtil.isNonExpressionPropertiesElement(currentElement = currentElement.getParent())) continue;
            GradlePropertiesDslElement element = (GradlePropertiesDslElement)currentElement;
            results.putAll(element.getVariableElements());
        }
        if (currentElement instanceof GradleBuildFile) {
            for (GradleBuildFile file = (GradleBuildFile)currentElement; file != null; file = file.getParentModuleBuildFile()) {
                ExtDslElement buildScriptExt;
                BuildScriptDslElement buildScriptElement;
                GradlePropertiesFile propertiesFile;
                ExtDslElement ext = file.getPropertyElement(ExtDslElement.EXT);
                if (ext != null) {
                    results.putAll(ext.getPropertyElements());
                }
                if ((propertiesFile = file.getPropertiesFile()) != null) {
                    Map<String, GradleDslElement> filteredProperties = ((GradlePropertiesDslElement)propertiesFile).getPropertyElements().entrySet().stream().filter(entry -> !((String)entry.getKey()).contains(".")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    results.putAll(filteredProperties);
                }
                if ((buildScriptElement = file.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT)) == null || (buildScriptExt = buildScriptElement.getPropertyElement(ExtDslElement.EXT)) == null) continue;
                results.putAll(buildScriptExt.getPropertyElements());
            }
        } else if (currentElement instanceof GradleVersionCatalogFile && (map = ((GradleVersionCatalogFile)currentElement).getPropertyElement(GradleDslExpressionMap.VERSIONS)) != null) {
            Map<String, GradleDslElement> versions = map.getPropertyElements();
            results.putAll(versions.entrySet().stream().collect(Collectors.toMap(e -> "versions." + (String)e.getKey(), Map.Entry::getValue)));
        }
        LinkedHashMap<String, GradleDslElement> linkedHashMap = results;
        if (linkedHashMap == null) {
            GradleDslElementImpl.$$$reportNull$$$0(22);
        }
        return linkedHashMap;
    }

    @Override
    @NotNull
    public <T extends BuildModelNotification> T notification(@NotNull NotificationTypeReference<T> type) {
        if (type == null) {
            GradleDslElementImpl.$$$reportNull$$$0(23);
        }
        T t = this.getDslFile().getContext().getNotificationForType(this.myDslFile, type);
        if (t == null) {
            GradleDslElementImpl.$$$reportNull$$$0(24);
        }
        return t;
    }

    @Override
    public void registerDependent(@NotNull GradleReferenceInjection injection) {
        if (injection == null) {
            GradleDslElementImpl.$$$reportNull$$$0(25);
        }
        assert (injection.isResolved() && injection.getToBeInjected() == this);
        this.myDependents.add(injection);
    }

    @Override
    public void unregisterDependent(@NotNull GradleReferenceInjection injection) {
        if (injection == null) {
            GradleDslElementImpl.$$$reportNull$$$0(26);
        }
        assert (injection.isResolved() && injection.getToBeInjected() == this);
        assert (this.myDependents.contains(injection));
        this.myDependents.remove(injection);
    }

    @Override
    public void unregisterAllDependants() {
        this.myDependents.forEach(e -> {
            e.resolveWith(null);
            this.getDslFile().getContext().getDependencyManager().registerUnresolvedReference((GradleReferenceInjection)e);
        });
        this.myDependents.clear();
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependents() {
        return new ArrayList<GradleReferenceInjection>(this.myDependents);
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        return new ArrayList<GradleReferenceInjection>(this.myDependencies);
    }

    @Override
    public void updateDependenciesOnAddElement(@NotNull GradleDslElement newElement) {
        if (newElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(27);
        }
        newElement.resolve();
        newElement.getDslFile().getContext().getDependencyManager().resolveWith(newElement);
    }

    @Override
    public void updateDependenciesOnReplaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (oldElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(28);
        }
        if (newElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(29);
        }
        List<GradleReferenceInjection> injections = oldElement.getDependents();
        oldElement.unregisterAllDependants();
        injections.forEach(e -> e.resolveWith(newElement));
        injections.forEach(newElement::registerDependent);
        oldElement.getResolvedVariables().forEach(e -> {
            GradleDslElement toBeInjected = e.getToBeInjected();
            if (toBeInjected != null) {
                toBeInjected.unregisterDependent((GradleReferenceInjection)e);
            }
        });
    }

    @Override
    public void updateDependenciesOnRemoveElement(@NotNull GradleDslElement oldElement) {
        if (oldElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(30);
        }
        List<GradleReferenceInjection> dependents = oldElement.getDependents();
        oldElement.unregisterAllDependants();
        dependents.forEach(e -> e.getOriginElement().resolve());
        oldElement.getResolvedVariables().forEach(e -> {
            GradleDslElement toBeInjected = e.getToBeInjected();
            if (toBeInjected != null) {
                toBeInjected.unregisterDependent((GradleReferenceInjection)e);
            }
        });
    }

    @Override
    public void addDependency(@NotNull GradleReferenceInjection injection) {
        if (injection == null) {
            GradleDslElementImpl.$$$reportNull$$$0(31);
        }
        this.myDependencies.add(injection);
    }

    @Override
    public void resolve() {
    }

    protected void reorder() {
        if (this.myParent instanceof ExtDslElement) {
            ((ExtDslElement)this.myParent).reorderAndMaybeGetNewIndex(this);
        }
    }

    @Override
    public long getModificationCount() {
        return this.myModificationCount;
    }

    public long getLastCommittedModificationCount() {
        return this.myLastCommittedModificationCount;
    }

    @Override
    public void modify() {
        HashSet<GradleDslElement> visited = new HashSet<GradleDslElement>();
        this.modify(visited);
    }

    protected void modify(Set<GradleDslElement> visited) {
        ++this.myModificationCount;
        visited.add(this);
        this.myDependents.forEach(e -> {
            if (!visited.contains(e.getOriginElement())) {
                e.getOriginElement().modify(visited);
            }
        });
    }

    public void commit() {
        this.myLastCommittedModificationCount = this.myModificationCount;
    }

    @Nullable
    public static String getPsiText(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(32);
        }
        return (String)ApplicationManager.getApplication().runReadAction(() -> psiElement.getText());
    }

    @Override
    public boolean isNewEmptyBlockElement() {
        if (this.myPsiElement != null) {
            return false;
        }
        if (!this.isBlockElement() || !this.isInsignificantIfEmpty()) {
            return false;
        }
        List<GradleDslElement> children = this.getContainedElements(true);
        if (children.isEmpty()) {
            return true;
        }
        for (GradleDslElement child : children) {
            if (child.isNewEmptyBlockElement()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ExternalToModelMap getExternalToModelMap(@NotNull GradleDslNameConverter converter) {
        if (converter == null) {
            GradleDslElementImpl.$$$reportNull$$$0(33);
        }
        return GradleDslElementImpl.getExternalToModelMap(converter, ExternalToModelMap.empty, ExternalToModelMap.empty, ExternalToModelMap.empty);
    }

    @NotNull
    protected static ExternalToModelMap getExternalToModelMap(@NotNull GradleDslNameConverter converter, ExternalToModelMap groovy, ExternalToModelMap kts) {
        if (converter == null) {
            GradleDslElementImpl.$$$reportNull$$$0(34);
        }
        return GradleDslElementImpl.getExternalToModelMap(converter, groovy, kts, kts);
    }

    @NotNull
    protected static ExternalToModelMap getExternalToModelMap(@NotNull GradleDslNameConverter converter, ExternalToModelMap groovy, ExternalToModelMap kts, ExternalToModelMap declarative) {
        if (converter == null) {
            GradleDslElementImpl.$$$reportNull$$$0(35);
        }
        return GradleDslElementImpl.getExternalProperties(converter.getKind(), groovy, kts, declarative);
    }

    @NotNull
    protected static ExternalToModelMap getExternalProperties(@NotNull GradleDslNameConverter.Kind kind, ExternalToModelMap groovy, ExternalToModelMap kts) {
        if (kind == null) {
            GradleDslElementImpl.$$$reportNull$$$0(36);
        }
        return GradleDslElementImpl.getExternalProperties(kind, groovy, kts, kts);
    }

    @NotNull
    protected static ExternalToModelMap getExternalProperties(@NotNull GradleDslNameConverter.Kind kind, ExternalToModelMap groovy, ExternalToModelMap kts, ExternalToModelMap declarative) {
        if (kind == null) {
            GradleDslElementImpl.$$$reportNull$$$0(37);
        }
        switch (kind) {
            case NONE: {
                ExternalToModelMap externalToModelMap = ExternalToModelMap.empty;
                if (externalToModelMap == null) {
                    GradleDslElementImpl.$$$reportNull$$$0(38);
                }
                return externalToModelMap;
            }
            case GROOVY: {
                ExternalToModelMap externalToModelMap = groovy;
                if (externalToModelMap == null) {
                    GradleDslElementImpl.$$$reportNull$$$0(39);
                }
                return externalToModelMap;
            }
            case KOTLIN: {
                ExternalToModelMap externalToModelMap = kts;
                if (externalToModelMap == null) {
                    GradleDslElementImpl.$$$reportNull$$$0(40);
                }
                return externalToModelMap;
            }
            case DECLARATIVE: {
                ExternalToModelMap externalToModelMap = declarative;
                if (externalToModelMap == null) {
                    GradleDslElementImpl.$$$reportNull$$$0(41);
                }
                return externalToModelMap;
            }
        }
        ExternalToModelMap externalToModelMap = ExternalToModelMap.empty;
        if (externalToModelMap == null) {
            GradleDslElementImpl.$$$reportNull$$$0(42);
        }
        return externalToModelMap;
    }

    @Override
    @Nullable
    public ModelEffectDescription getModelEffect() {
        return this.myModelEffectDescription;
    }

    @Override
    public void setModelEffect(@Nullable ModelEffectDescription effect) {
        this.myModelEffectDescription = effect;
    }

    @Override
    @Nullable
    public ModelPropertyDescription getModelProperty() {
        return this.myModelEffectDescription == null ? null : this.myModelEffectDescription.property;
    }

    @Nullable
    public static GradleDslElement dereference(@NotNull GradleDslElement element, @NotNull String index) {
        if (element == null) {
            GradleDslElementImpl.$$$reportNull$$$0(43);
        }
        if (index == null) {
            GradleDslElementImpl.$$$reportNull$$$0(44);
        }
        if (element instanceof GradleDslExpressionList) {
            int offset;
            try {
                offset = Integer.parseInt(index);
            }
            catch (NumberFormatException e) {
                return null;
            }
            GradleDslExpressionList list = (GradleDslExpressionList)element;
            if (list.getExpressions().size() <= offset) {
                return null;
            }
            return list.getExpressions().get(offset);
        }
        if (element instanceof GradleDslExpressionMap) {
            GradleDslExpressionMap map = (GradleDslExpressionMap)element;
            index = GradleDslElementImpl.stripQuotes(index);
            return map.getPropertyElement(index);
        }
        GradleDslElement value = PropertyUtil.followElement(element);
        if (value == null) {
            return null;
        }
        if (value != element) {
            return GradleDslElementImpl.dereference(value, index);
        }
        return null;
    }

    @Nullable
    private static GradleDslElement extractElementFromProperties(@NotNull GradlePropertiesDslElement properties, @NotNull String name2, GradleDslNameConverter converter, boolean sameScope, @Nullable GradleDslElement childElement, boolean includeSelf) {
        Matcher indexMatcher;
        if (properties == null) {
            GradleDslElementImpl.$$$reportNull$$$0(45);
        }
        if (name2 == null) {
            GradleDslElementImpl.$$$reportNull$$$0(46);
        }
        if (!(indexMatcher = GradleNameElement.INDEX_PATTERN.matcher(name2)).find()) {
            ModelPropertyDescription property = converter.modelDescriptionForParent(name2, properties);
            String modelName = property == null ? name2 : property.name;
            return sameScope ? properties.getElementBefore(childElement, modelName, includeSelf) : properties.getPropertyElementBefore(childElement, modelName, includeSelf);
        }
        String elementName = indexMatcher.group(0);
        if (elementName == null || elementName.isEmpty()) {
            return null;
        }
        ModelPropertyDescription property = converter.modelDescriptionForParent(elementName, properties);
        String modelName = property == null ? elementName : property.name;
        GradleDslElement element = sameScope ? properties.getElementBefore(childElement, modelName, includeSelf) : properties.getPropertyElementBefore(childElement, modelName, includeSelf);
        ArrayDeque<String> indexParts = new ArrayDeque<String>();
        while (indexMatcher.find()) {
            String match = indexMatcher.group(1);
            if (match == null) {
                return null;
            }
            indexParts.add(match);
        }
        while (!indexParts.isEmpty()) {
            String index = (String)indexParts.pop();
            if (element == null) {
                return null;
            }
            element = GradleDslElementImpl.dereference(element, index);
        }
        return element;
    }

    @Nullable
    private static GradleBuildFile findBuildFile(GradleBuildFile rootModuleBuildFile, File moduleDirectory) {
        if (FileUtil.filesEqual((File)rootModuleBuildFile.getDirectoryPath(), (File)moduleDirectory)) {
            return rootModuleBuildFile;
        }
        for (GradleBuildFile buildFile : rootModuleBuildFile.getChildModuleBuildFiles()) {
            if (FileUtil.filesEqual((File)buildFile.getDirectoryPath(), (File)moduleDirectory)) {
                return buildFile;
            }
            GradleBuildFile childBuildFile = GradleDslElementImpl.findBuildFile(buildFile, moduleDirectory);
            if (childBuildFile == null) continue;
            return buildFile;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnPropertiesElement(@NotNull GradlePropertiesDslElement properties, @NotNull List<String> nameParts, GradleDslNameConverter converter, @NotNull List<GradleDslElement> trace) {
        if (properties == null) {
            GradleDslElementImpl.$$$reportNull$$$0(47);
        }
        if (nameParts == null) {
            GradleDslElementImpl.$$$reportNull$$$0(48);
        }
        if (trace == null) {
            GradleDslElementImpl.$$$reportNull$$$0(49);
        }
        int traceIndex = trace.size() - 1;
        for (int i = 0; i < nameParts.size() - 1; ++i) {
            GradleDslElement element = GradleDslElementImpl.extractElementFromProperties(properties, nameParts.get(i), converter, i == 0, traceIndex < 0 ? null : trace.get(traceIndex--), traceIndex >= 0);
            if (element == null) {
                return null;
            }
            if (!PropertyUtil.isPropertiesElementOrMap(element = PropertyUtil.followElement(element))) {
                return null;
            }
            properties = (GradlePropertiesDslElement)element;
        }
        return GradleDslElementImpl.extractElementFromProperties(properties, nameParts.get(nameParts.size() - 1), converter, nameParts.size() == 1, traceIndex < 0 ? null : trace.get(traceIndex--), traceIndex >= 0);
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnElement(@NotNull GradleDslElement element, @NotNull List<String> nameParts, GradleDslNameConverter converter, boolean resolveWithOrder, boolean checkExt, int ignoreParentNumber) {
        if (element == null) {
            GradleDslElementImpl.$$$reportNull$$$0(50);
        }
        if (nameParts == null) {
            GradleDslElementImpl.$$$reportNull$$$0(51);
        }
        Stack<GradleDslElement> elementTrace = new Stack<GradleDslElement>();
        if (resolveWithOrder) {
            elementTrace.push(element);
        }
        while (ignoreParentNumber-- > 0 && element != null && !(element instanceof GradleDslFile) && !(element instanceof BuildScriptDslElement)) {
            element = element.getParent();
        }
        while (element != null) {
            GradleDslElement lastElement;
            GradleDslElement gradleDslElement = lastElement = elementTrace.isEmpty() ? null : (GradleDslElement)elementTrace.peek();
            if (PropertyUtil.isPropertiesElementOrMap(element)) {
                GradleDslElement bsElement;
                GradleDslElement bsDslElement;
                GradleDslElement extPropertyElement;
                GradleDslElement extElement;
                GradleDslElement propertyElement = GradleDslElementImpl.resolveReferenceOnPropertiesElement((GradlePropertiesDslElement)element, nameParts, converter, elementTrace);
                if (propertyElement != null) {
                    return propertyElement;
                }
                if (!(lastElement instanceof ExtDslElement) && checkExt && (extElement = ((GradlePropertiesDslElement)element).getPropertyElementBefore(lastElement, ExtDslElement.EXT.name, false)) instanceof ExtDslElement && (extPropertyElement = GradleDslElementImpl.resolveReferenceOnPropertiesElement((ExtDslElement)extElement, nameParts, converter, elementTrace)) != null) {
                    return extPropertyElement;
                }
                if (!(lastElement instanceof BuildScriptDslElement) && (bsDslElement = ((GradlePropertiesDslElement)element).getPropertyElementBefore(element, BuildScriptDslElement.BUILDSCRIPT.name, false)) instanceof BuildScriptDslElement && (bsElement = GradleDslElementImpl.resolveReferenceOnElement(bsDslElement, nameParts, converter, true, false, -1)) != null) {
                    return bsElement;
                }
            }
            if (resolveWithOrder) {
                elementTrace.push(element);
            }
            if (element instanceof BuildScriptDslElement) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInPropertiesFile(@NotNull GradleBuildFile buildDslFile, @NotNull String referenceText) {
        GradlePropertiesFile propertiesDslFile;
        if (buildDslFile == null) {
            GradleDslElementImpl.$$$reportNull$$$0(52);
        }
        if (referenceText == null) {
            GradleDslElementImpl.$$$reportNull$$$0(53);
        }
        return (propertiesDslFile = buildDslFile.getPropertiesFile()) != null ? ((GradlePropertiesDslElement)propertiesDslFile).getPropertyElement(referenceText) : null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInVersionCatalogs(@NotNull BuildModelContext context, @NotNull List<String> referenceParts) {
        if (context == null) {
            GradleDslElementImpl.$$$reportNull$$$0(54);
        }
        if (referenceParts == null) {
            GradleDslElementImpl.$$$reportNull$$$0(55);
        }
        if (referenceParts.size() < 2) {
            return null;
        }
        String catalog = referenceParts.get(0);
        for (GradleVersionCatalogFile versionCatalogFile : context.getVersionCatalogFiles()) {
            GradleDslElement table;
            Pattern pattern;
            if (!catalog.equals(versionCatalogFile.getCatalogName())) continue;
            String tableName = referenceParts.get(1);
            if ("plugins".equals(tableName) || "bundles".equals(tableName) || "versions".equals(tableName)) {
                pattern = Pattern.compile(String.join((CharSequence)"[-_.]", referenceParts.stream().skip(2L).map(Pattern::quote).toList()));
                table = versionCatalogFile.getElement(tableName);
            } else {
                pattern = Pattern.compile(String.join((CharSequence)"[-_.]", referenceParts.stream().skip(1L).map(Pattern::quote).toList()));
                table = versionCatalogFile.getElement("libraries");
            }
            if (table == null) {
                return null;
            }
            for (GradleDslElement element : table.getChildren()) {
                if (!pattern.matcher(element.getName()).matches()) continue;
                return element;
            }
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInParentModules(@NotNull GradleBuildFile buildFile, @NotNull List<String> referenceText, GradleDslNameConverter converter) {
        if (buildFile == null) {
            GradleDslElementImpl.$$$reportNull$$$0(56);
        }
        if (referenceText == null) {
            GradleDslElementImpl.$$$reportNull$$$0(57);
        }
        for (GradleBuildFile parentBuildFile = buildFile.getParentModuleBuildFile(); parentBuildFile != null; parentBuildFile = parentBuildFile.getParentModuleBuildFile()) {
            GradleDslElement bsElement;
            GradleDslElement extPropertyElement;
            ExtDslElement extDslElement = parentBuildFile.getPropertyElement(ExtDslElement.EXT);
            if (extDslElement != null && (extPropertyElement = GradleDslElementImpl.resolveReferenceOnPropertiesElement(extDslElement, referenceText, converter, new Stack<GradleDslElement>())) != null) {
                return extPropertyElement;
            }
            BuildScriptDslElement bsDslElement = parentBuildFile.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
            if (bsDslElement != null && (bsElement = GradleDslElementImpl.resolveReferenceOnElement(bsDslElement, referenceText, converter, false, true, -1)) != null) {
                return bsElement;
            }
            if (parentBuildFile.getParentModuleBuildFile() == null) {
                return null;
            }
            GradleDslElement propertyElement = GradleDslElementImpl.resolveReferenceInPropertiesFile(parentBuildFile, String.join((CharSequence)".", referenceText));
            if (propertyElement == null) continue;
            return propertyElement;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInSameModule(@NotNull GradleDslElement startElement, @NotNull List<String> referenceText, GradleDslNameConverter converter, boolean resolveWithOrder) {
        GradleDslExpressionMap libraries;
        GradleDslElement element;
        GradleDslExpressionMap versions;
        if (startElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(58);
        }
        if (referenceText == null) {
            GradleDslElementImpl.$$$reportNull$$$0(59);
        }
        if (startElement.getDslFile() instanceof GradleVersionCatalogFile && referenceText.size() == 1 && ((versions = startElement.getDslFile().getPropertyElement("versions", GradleDslExpressionMap.class)) != null ? (element = GradleDslElementImpl.resolveReferenceOnElement(versions, referenceText, converter, false, false, -1)) != null : (libraries = startElement.getDslFile().getPropertyElement("libraries", GradleDslExpressionMap.class)) != null && (element = GradleDslElementImpl.resolveReferenceOnElement(libraries, referenceText, converter, false, false, -1)) != null)) {
            return element;
        }
        element = GradleDslElementImpl.resolveReferenceOnElement(startElement, referenceText, converter, resolveWithOrder, true, startElement.getNameElement().fullNameParts().size());
        if (element != null) {
            return element;
        }
        String text = String.join((CharSequence)".", referenceText);
        GradleDslFile dslFile = startElement.getDslFile();
        if (dslFile instanceof GradleBuildFile) {
            GradleDslElement bsElement;
            GradleBuildFile buildFile = (GradleBuildFile)dslFile;
            GradleDslElement propertyElement = GradleDslElementImpl.resolveReferenceInPropertiesFile(buildFile, text);
            if (propertyElement != null) {
                return propertyElement;
            }
            BuildScriptDslElement bsDslElement = buildFile.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
            if (bsDslElement != null && (bsElement = GradleDslElementImpl.resolveReferenceOnElement(bsDslElement, referenceText, converter, false, true, -1)) != null) {
                return bsElement;
            }
            GradleDslElement versionCatalogElement = GradleDslElementImpl.resolveReferenceInVersionCatalogs(buildFile.getContext(), referenceText);
            if (versionCatalogElement != null) {
                return versionCatalogElement;
            }
            GradleBuildFile rootProjectBuildFile = buildFile.getContext().getRootProjectFile();
            if (rootProjectBuildFile == null || buildFile == rootProjectBuildFile) {
                return null;
            }
            return GradleDslElementImpl.resolveReferenceInPropertiesFile(rootProjectBuildFile, text);
        }
        return null;
    }

    @Override
    @Nullable
    public GradleDslElement resolveExternalSyntaxReference(@NotNull String referenceText, boolean resolveWithOrder) {
        GradleDslElementImpl searchStartElement;
        if (referenceText == null) {
            GradleDslElementImpl.$$$reportNull$$$0(60);
        }
        if ((searchStartElement = this).getDslFile() instanceof GradleVersionCatalogFile) {
            if (((String)referenceText).startsWith("versions.")) {
                referenceText = DOUBLE_QUOTES + ((String)referenceText).substring("versions.".length()) + DOUBLE_QUOTES;
            } else if (((String)referenceText).startsWith("libraries.")) {
                referenceText = DOUBLE_QUOTES + ((String)referenceText).substring("libraries.".length()) + DOUBLE_QUOTES;
            }
        }
        GradleDslParser parser = this.getDslFile().getParser();
        referenceText = parser.convertReferenceText(searchStartElement, (String)referenceText);
        return this.resolveInternalSyntaxReference((String)referenceText, resolveWithOrder);
    }

    @Override
    @Nullable
    public GradleDslElement resolveExternalSyntaxReference(@NotNull PsiElement psiElement, boolean resolveWithOrder) {
        if (psiElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(61);
        }
        GradleDslElementImpl searchStartElement = this;
        GradleDslParser parser = this.getDslFile().getParser();
        String referenceText = parser.convertReferencePsi(searchStartElement, psiElement);
        return this.resolveInternalSyntaxReference(referenceText, resolveWithOrder);
    }

    @Override
    @Nullable
    public GradleDslElement resolveInternalSyntaxReference(@NotNull String referenceText, boolean resolveWithOrder) {
        GradleBuildFile buildFile;
        int index;
        if (referenceText == null) {
            GradleDslElementImpl.$$$reportNull$$$0(62);
        }
        GradleDslElementImpl searchStartElement = this;
        GradleDslParser parser = this.getDslFile().getParser();
        boolean withinBuildscript = false;
        GradleDslElement element = this;
        while (element != null) {
            if (!((element = element.getParent()) instanceof BuildScriptDslElement)) continue;
            withinBuildscript = true;
            break;
        }
        List<String> referenceTextSegments = GradleNameElement.split(referenceText);
        int segmentCount = referenceTextSegments.size();
        for (index = 0; index < segmentCount && (buildFile = GradleDslElementImpl.resolveProjectReference(searchStartElement, referenceTextSegments.get(index))) != null; ++index) {
            searchStartElement = buildFile;
        }
        GradleDslElement resolvedElement = null;
        GradleDslFile dslFile = searchStartElement.getDslFile();
        if (index >= segmentCount) {
            resolvedElement = searchStartElement;
        } else {
            referenceTextSegments = referenceTextSegments.subList(index, segmentCount);
            if (dslFile == searchStartElement && withinBuildscript) {
                searchStartElement = dslFile.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
            }
            if (searchStartElement != null) {
                resolvedElement = GradleDslElementImpl.resolveReferenceInSameModule(searchStartElement, referenceTextSegments, parser, resolveWithOrder);
            }
        }
        if (resolvedElement == null && dslFile instanceof GradleBuildFile) {
            GradleBuildFile buildFile2 = (GradleBuildFile)dslFile;
            resolvedElement = GradleDslElementImpl.resolveReferenceInParentModules(buildFile2, referenceTextSegments, parser);
        }
        return resolvedElement;
    }

    @Nullable
    private static GradleBuildFile resolveProjectReference(GradleDslElement startElement, @NotNull String projectReference) {
        GradleDslFile dslFile;
        if (projectReference == null) {
            GradleDslElementImpl.$$$reportNull$$$0(63);
        }
        if ((dslFile = startElement.getDslFile()) instanceof GradleBuildFile) {
            GradleBuildFile buildFile;
            if ("project".equals(projectReference)) {
                return buildFile;
            }
            if ("parent".equals(projectReference)) {
                return buildFile.getParentModuleBuildFile();
            }
            if ("rootProject".equals(projectReference)) {
                for (buildFile = (GradleBuildFile)dslFile; buildFile != null && !FileUtil.filesEqual((File)buildFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)buildFile.getProject().getBaseDir())); buildFile = buildFile.getParentModuleBuildFile()) {
                }
                return buildFile;
            }
            String standardProjectKey = ProjectPropertiesDslElement.getStandardProjectKey(projectReference);
            if (standardProjectKey != null) {
                String modulePath = standardProjectKey.substring(standardProjectKey.indexOf(39) + 1, standardProjectKey.lastIndexOf(39));
                VirtualFile settingFile = buildFile.tryToFindSettingsFile();
                if (settingFile == null) {
                    return null;
                }
                GradleSettingsFile file = buildFile.getContext().getOrCreateSettingsFile(settingFile);
                GradleSettingsModelImpl model = new GradleSettingsModelImpl(file);
                File moduleDirectory = model.moduleDirectory(modulePath);
                if (moduleDirectory == null) {
                    return null;
                }
                while (buildFile != null && !FileUtil.filesEqual((File)buildFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)buildFile.getProject().getBaseDir()))) {
                    buildFile = buildFile.getParentModuleBuildFile();
                }
                if (buildFile == null) {
                    return null;
                }
                return GradleDslElementImpl.findBuildFile(buildFile, moduleDirectory);
            }
        }
        return null;
    }

    @NotNull
    private static String stripQuotes(@NotNull String index) {
        if (index == null) {
            GradleDslElementImpl.$$$reportNull$$$0(64);
        }
        if (index.startsWith(SINGLE_QUOTES) && index.endsWith(SINGLE_QUOTES) || index.startsWith(DOUBLE_QUOTES) && index.endsWith(DOUBLE_QUOTES)) {
            String string = index.substring(1, index.length() - 1);
            if (string == null) {
                GradleDslElementImpl.$$$reportNull$$$0(65);
            }
            return string;
        }
        String string = index;
        if (string == null) {
            GradleDslElementImpl.$$$reportNull$$$0(66);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 12, 14, 16, 18, 19, 21, 22, 24, 38, 39, 40, 41, 42, 65, 66 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closureElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchicalName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntax";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyType";
                break;
            }
            case 20: 
            case 43: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 32: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 44: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameParts";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDslFile";
                break;
            }
            case 53: 
            case 57: 
            case 59: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceParts";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHolders";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSyntax";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDslFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedVariables";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainedElements";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInScopeElements";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "notification";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProperties";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setParsedClosureElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 65: 
            case 66: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setNameElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addHolder";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setExternalSyntax";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setElementType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "requestAnchor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "notification";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "registerDependent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "unregisterDependent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesOnAddElement";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesOnReplaceElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesOnRemoveElement";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPsiText";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getExternalToModelMap";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProperties";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "dereference";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "extractElementFromProperties";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceOnPropertiesElement";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceOnElement";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInPropertiesFile";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInVersionCatalogs";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInParentModules";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInSameModule";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "resolveExternalSyntaxReference";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "resolveInternalSyntaxReference";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectReference";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 12, 14, 16, 18, 19, 21, 22, 24, 38, 39, 40, 41, 42, 65, 66 -> new IllegalStateException(string);
        };
    }
}

