/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.html;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.plugins.markdown.extensions.CodeFenceGeneratingProvider;
import org.intellij.plugins.markdown.extensions.common.highlighter.FenceHighlightingKt;
import org.intellij.plugins.markdown.extensions.common.highlighter.MarkdownCodeFencePreviewHighlighter;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension;
import org.intellij.plugins.markdown.lang.psi.util.MarkdownAstUtilsKt;
import org.intellij.plugins.markdown.ui.preview.html.PreviewEncodingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ*\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J.\u0010\u0013\u001a\u00020\r*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0002J$\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bR\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\rH\u0002J$\u0010\u001e\u001a\u00020\u00192\n\u0010 \u001a\u00060!j\u0002`\"2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u001c\u0010#\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bR\u00020\u001c2\u0006\u0010$\u001a\u00020\rH\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010'\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/DefaultCodeFenceGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "cacheProviders", "", "Lorg/intellij/plugins/markdown/extensions/CodeFenceGeneratingProvider;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "([Lorg/intellij/plugins/markdown/extensions/CodeFenceGeneratingProvider;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "[Lorg/intellij/plugins/markdown/extensions/CodeFenceGeneratingProvider;", "pluginGeneratedHtml", "", "language", "codeFenceContent", "codeFenceRawContent", "node", "Lorg/intellij/markdown/ast/ASTNode;", "generateHtmlWithFile", "raw", "processCodeBlock", "processCodeLine", "rawCodeLine", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "collectFenceText", "allText", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addCopyButton", "content", "codeFenceRawText", "", "codeFenceText", "Companion", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nDefaultCodeFenceGeneratingProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCodeFenceGeneratingProvider.kt\norg/intellij/plugins/markdown/ui/preview/html/DefaultCodeFenceGeneratingProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,178:1\n1310#2,2:179\n1#3:181\n37#4,2:182\n37#4,2:184\n*S KotlinDebug\n*F\n+ 1 DefaultCodeFenceGeneratingProvider.kt\norg/intellij/plugins/markdown/ui/preview/html/DefaultCodeFenceGeneratingProvider\n*L\n33#1:179,2\n96#1:182,2\n109#1:184,2\n*E\n"})
public final class DefaultCodeFenceGeneratingProvider
implements GeneratingProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeFenceGeneratingProvider[] cacheProviders;
    @Nullable
    private final Project project;
    @Nullable
    private final VirtualFile file;

    public DefaultCodeFenceGeneratingProvider(@NotNull CodeFenceGeneratingProvider[] cacheProviders, @Nullable Project project, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)cacheProviders, (String)"cacheProviders");
        this.cacheProviders = cacheProviders;
        this.project = project;
        this.file = file;
    }

    public /* synthetic */ DefaultCodeFenceGeneratingProvider(CodeFenceGeneratingProvider[] codeFenceGeneratingProviderArray, Project project, VirtualFile virtualFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            virtualFile = null;
        }
        this(codeFenceGeneratingProviderArray, project, virtualFile);
    }

    private final String pluginGeneratedHtml(String language, String codeFenceContent, String codeFenceRawContent, ASTNode node) {
        CodeFenceGeneratingProvider codeFenceGeneratingProvider;
        block2: {
            if (language == null) {
                return FenceHighlightingKt.buildHighlightedFenceContent(codeFenceContent, CollectionsKt.emptyList(), node, true, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)this){

                    public final String invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return DefaultCodeFenceGeneratingProvider.access$processCodeLine((DefaultCodeFenceGeneratingProvider)this.receiver, p0);
                    }
                }));
            }
            CodeFenceGeneratingProvider[] $this$firstOrNull$iv = this.cacheProviders;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                CodeFenceGeneratingProvider element$iv;
                CodeFenceGeneratingProvider it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!it.isApplicable(language)) continue;
                codeFenceGeneratingProvider = element$iv;
                break block2;
            }
            codeFenceGeneratingProvider = null;
        }
        CodeFenceGeneratingProvider provider = codeFenceGeneratingProvider;
        String html2 = provider == null ? FenceHighlightingKt.buildHighlightedFenceContent(codeFenceContent, CollectionsKt.emptyList(), node, true, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)this){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DefaultCodeFenceGeneratingProvider.access$processCodeLine((DefaultCodeFenceGeneratingProvider)this.receiver, p0);
            }
        })) : this.generateHtmlWithFile(provider, language, codeFenceRawContent, node, this.file);
        return this.processCodeBlock(codeFenceRawContent, language) + html2;
    }

    private final String generateHtmlWithFile(CodeFenceGeneratingProvider $this$generateHtmlWithFile, String language, String raw, ASTNode node, VirtualFile file) {
        return $this$generateHtmlWithFile instanceof MarkdownCodeFencePreviewHighlighter && file != null ? ((MarkdownCodeFencePreviewHighlighter)$this$generateHtmlWithFile).generateHtmlForFile(language, raw, node, file) : $this$generateHtmlWithFile.generateHtml(language, raw, node);
    }

    private final String processCodeBlock(String codeFenceRawContent, String language) {
        Object object;
        block3: {
            block2: {
                object = this.file;
                if (object == null) break block2;
                VirtualFile virtualFile = object;
                CommandRunnerExtension.Companion companion = CommandRunnerExtension.Companion;
                VirtualFile p0 = virtualFile;
                boolean $i$f$processCodeBlock$stub_for_inlining = false;
                boolean bl = false;
                CommandRunnerExtension commandRunnerExtension = companion.getRunnerByFile(p0);
                object = commandRunnerExtension;
                if (commandRunnerExtension != null && (object = ((CommandRunnerExtension)object).processCodeBlock(codeFenceRawContent, language)) != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final String processCodeLine(String rawCodeLine) {
        Object object;
        block3: {
            block2: {
                object = this.file;
                if (object == null) break block2;
                VirtualFile virtualFile = object;
                CommandRunnerExtension.Companion companion = CommandRunnerExtension.Companion;
                VirtualFile p0 = virtualFile;
                boolean $i$f$processCodeLine$stub_for_inlining$1 = false;
                boolean bl = false;
                CommandRunnerExtension commandRunnerExtension = companion.getRunnerByFile(p0);
                object = commandRunnerExtension;
                if (commandRunnerExtension != null && (object = ((CommandRunnerExtension)object).processCodeLine(rawCodeLine, true)) != null) break block3;
            }
            object = "";
        }
        return object;
    }

    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text2, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int indentBefore = StringsKt.commonPrefixWith$default((CharSequence)ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)text2), (CharSequence)StringsKt.repeat((CharSequence)" ", (int)10), (boolean)false, (int)2, null).length();
        visitor2.consumeHtml((CharSequence)("<pre class=\"code-fence\" " + HtmlGenerator.Companion.getSrcPosAttribute(node) + ">"));
        this.addCopyButton(visitor2, ((Object)StringsKt.trim((CharSequence)this.collectFenceText(node, text2))).toString());
        boolean state = false;
        List childrenToConsider = node.getChildren();
        if (Intrinsics.areEqual((Object)((ASTNode)CollectionsKt.last((List)childrenToConsider)).getType(), (Object)MarkdownTokenTypes.CODE_FENCE_END)) {
            childrenToConsider = childrenToConsider.subList(0, childrenToConsider.size() - 1);
        }
        boolean lastChildWasContent = false;
        ArrayList<CallSite> attributes = new ArrayList<CallSite>();
        String language = null;
        StringBuilder codeFenceRawContent = new StringBuilder();
        StringBuilder codeFenceContent = new StringBuilder();
        for (ASTNode child : childrenToConsider) {
            Object[] objectArray;
            if (state && CollectionsKt.listOf((Object[])(objectArray = new IElementType[]{MarkdownTokenTypes.CODE_FENCE_CONTENT, MarkdownTokenTypes.EOL})).contains(child.getType())) {
                codeFenceRawContent.append(HtmlGenerator.Companion.trimIndents(this.codeFenceRawText(text2, child), indentBefore));
                codeFenceContent.append(HtmlGenerator.Companion.trimIndents(this.codeFenceText(text2, child), indentBefore));
                lastChildWasContent = Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT);
            }
            if (!state && Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.FENCE_LANG)) {
                language = ((Object)StringsKt.trim((CharSequence)((Object)HtmlGenerator.Companion.leafText$default((HtmlGenerator.Companion)HtmlGenerator.Companion, (String)text2, (ASTNode)child, (boolean)false, (int)4, null)).toString())).toString();
                objectArray = new String[]{" "};
                attributes.add((CallSite)((Object)("class=\"language-" + CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)language, (String[])objectArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null) + "\"")));
            }
            if (state || !Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.EOL)) continue;
            Collection $this$toTypedArray$iv = attributes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new String[0]);
            HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor2, (ASTNode)node, (CharSequence)"code", (CharSequence[])((CharSequence[])Arrays.copyOf(objectArray, objectArray.length)), (boolean)false, (int)8, null);
            state = true;
        }
        String string = codeFenceRawContent.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String rawContentResult = string;
        if (state) {
            String string2 = codeFenceContent.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            visitor2.consumeHtml((CharSequence)this.pluginGeneratedHtml(language, string2, rawContentResult, node));
        }
        if (!state) {
            Collection $this$toTypedArray$iv = attributes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor2, (ASTNode)node, (CharSequence)"code", (CharSequence[])Arrays.copyOf(stringArray, stringArray.length), (boolean)false, (int)8, null);
        }
        if (lastChildWasContent) {
            visitor2.consumeHtml((CharSequence)"\n");
        }
        visitor2.consumeHtml((CharSequence)"</code></pre>");
    }

    private final String collectFenceText(ASTNode node, String allText) {
        StringBuilder stringBuilder;
        StringBuilder $this$collectFenceText_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.collectFenceText($this$collectFenceText_u24lambda_u242, node, allText);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void collectFenceText(StringBuilder builder, ASTNode node, String allText) {
        if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT) || Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.EOL)) {
            builder.append(this.codeFenceRawText(allText, node));
        }
        for (ASTNode child : node.getChildren()) {
            this.collectFenceText(builder, child, allText);
        }
    }

    private final void addCopyButton(HtmlGenerator.HtmlGeneratingVisitor visitor2, String content) {
        String encodedContent = PreviewEncodingUtil.INSTANCE.encodeContent(content);
        String html2 = StringsKt.trimIndent((String)("\n    <div class=\"code-fence-highlighter-copy-button\" data-fence-content=\"" + encodedContent + "\">\n      <img class=\"code-fence-highlighter-copy-button-icon\">\n      <span class=\"tooltiptext\">Copy to clipboard</span>\n    </div>\n    "));
        visitor2.consumeHtml((CharSequence)html2);
    }

    private final CharSequence codeFenceRawText(String text2, ASTNode node) {
        return Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.BLOCK_QUOTE) ? (CharSequence)"" : ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)text2);
    }

    private final CharSequence codeFenceText(String text2, ASTNode node) {
        return !Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.BLOCK_QUOTE) ? HtmlGenerator.Companion.leafText(text2, node, false) : (CharSequence)"";
    }

    public static final /* synthetic */ String access$processCodeLine(DefaultCodeFenceGeneratingProvider $this, String rawCodeLine) {
        return $this.processCodeLine(rawCodeLine);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/DefaultCodeFenceGeneratingProvider$Companion;", "", "<init>", "()V", "findFenceContentStart", "Lorg/intellij/markdown/ast/ASTNode;", "fence", "calculateCodeFenceContentBaseOffset", "", "calculateCodeFenceContentBaseOffset$intellij_markdown", "escape", "", "html", "escape$intellij_markdown", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nDefaultCodeFenceGeneratingProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCodeFenceGeneratingProvider.kt\norg/intellij/plugins/markdown/ui/preview/html/DefaultCodeFenceGeneratingProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ASTNode findFenceContentStart(ASTNode fence) {
            Object v1;
            block4: {
                Object v0;
                ASTNode it;
                Iterable iterable;
                List children2;
                block3: {
                    children2 = fence.getChildren();
                    iterable = children2;
                    for (Object t : iterable) {
                        it = (ASTNode)t;
                        boolean bl = false;
                        if (!MarkdownAstUtilsKt.hasType(it, MarkdownTokenTypes.FENCE_LANG)) continue;
                        v0 = t;
                        break block3;
                    }
                    v0 = null;
                }
                ASTNode language = v0;
                if (language != null) {
                    return language;
                }
                iterable = children2;
                for (Object t : iterable) {
                    it = (ASTNode)t;
                    boolean bl = false;
                    if (!MarkdownAstUtilsKt.hasType(it, MarkdownTokenTypes.CODE_FENCE_START)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            return v1;
        }

        public final int calculateCodeFenceContentBaseOffset$intellij_markdown(@NotNull ASTNode fence) {
            Intrinsics.checkNotNullParameter((Object)fence, (String)"fence");
            ASTNode start = this.findFenceContentStart(fence);
            return start == null ? fence.getStartOffset() : start.getEndOffset() + 1;
        }

        @NotNull
        public final String escape$intellij_markdown(@NotNull String html2) {
            Intrinsics.checkNotNullParameter((Object)html2, (String)"html");
            return EntityConverter.INSTANCE.replaceEntities((CharSequence)html2, true, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

