/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JList;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JListCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;

final class JListContentQuery {
    @Nonnull
    @RunsInEDT
    static String[] contents(@Nonnull JList<?> list, @Nonnull JListCellReader cellReader) {
        String[] result = GuiActionRunner.execute(() -> {
            String[] values = new String[list.getModel().getSize()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = cellReader.valueAt(list, i);
            }
            return values;
        });
        return Preconditions.checkNotNull(result);
    }

    private JListContentQuery() {
    }
}

