/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Strings;
import org.assertj.core.util.Throwables;

public class ShouldHaveCauseExactlyInstance
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldHaveCauseExactlyInstance(Throwable actual, Class<? extends Throwable> expectedCauseType) {
        return actual.getCause() == null ? new ShouldHaveCauseExactlyInstance(expectedCauseType, actual) : new ShouldHaveCauseExactlyInstance(actual, expectedCauseType);
    }

    private ShouldHaveCauseExactlyInstance(Throwable actual, Class<? extends Throwable> expectedCauseType) {
        super("%nExpecting a throwable with cause being exactly an instance of:%n  %s%nbut was an instance of:%n  %s%nThrowable that failed the check:%n%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedCauseType, actual.getCause().getClass());
    }

    private ShouldHaveCauseExactlyInstance(Class<? extends Throwable> expectedCauseType, Throwable actual) {
        super("%nExpecting a throwable with cause being exactly an instance of:%n  %s%nbut current throwable has no cause.%nThrowable that failed the check:%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedCauseType);
    }
}

