/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.config;

import com.intellij.configurationStore.StreamProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.settingsSync.DeleteServerDataResult;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncEventListener;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncLocalSettings;
import com.intellij.settingsSync.SettingsSyncLocalStateHolder;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.SettingsSyncState;
import com.intellij.settingsSync.SettingsSyncStatusTracker;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.settingsSync.UpdateResult;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.settingsSync.config.EnableSettingsSyncDialog;
import com.intellij.settingsSync.config.SettingsSyncConfigurable;
import com.intellij.settingsSync.config.SettingsSyncEnabler;
import com.intellij.settingsSync.config.SettingsSyncPanelFactory;
import com.intellij.settingsSync.statistics.SettingsSyncEventsStatistics;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 22\u00020\u00012\u00020\u00022\u00020\u0003:\u0005./012B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J\u001c\u0010\u001c\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\b\u0010!\u001a\u00020\u0017H\u0002J\b\u0010\"\u001a\u00020\u0017H\u0002J\"\u0010#\u001a\u00020\u00172\u000b\u0010$\u001a\u00070%\u00a2\u0006\u0002\b&2\u000b\u0010'\u001a\u00070%\u00a2\u0006\u0002\b&H\u0002J\b\u0010(\u001a\u00020\u0017H\u0002J\b\u0010)\u001a\u00020%H\u0002J\b\u0010*\u001a\u00020%H\u0002J\b\u0010+\u001a\u00020\u0017H\u0016J\b\u0010,\u001a\u00020\u0017H\u0016J\b\u0010-\u001a\u00020%H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/settingsSync/config/SettingsSyncEnabler$Listener;", "Lcom/intellij/settingsSync/SettingsSyncStatusTracker$Listener;", "<init>", "()V", "configPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "enableButton", "Lcom/intellij/ui/dsl/builder/Cell;", "Ljavax/swing/JButton;", "statusLabel", "Ljavax/swing/JLabel;", "marketplacePluginInstalled", "", "syncEnabler", "Lcom/intellij/settingsSync/config/SettingsSyncEnabler;", "MARKETPLACE_PLUGIN_ID", "Lcom/intellij/openapi/extensions/PluginId;", "Lorg/jetbrains/annotations/NotNull;", "createPanel", "settingsRepositoryIsEnabled", "serverStateCheckFinished", "", "state", "Lcom/intellij/settingsSync/UpdateResult;", "updateFromServerFinished", "result", "showEnableSyncDialog", "remoteSettings", "Lcom/intellij/settingsSync/SettingsSyncState;", "remoteSyncScopeSettings", "Lcom/intellij/settingsSync/SettingsSyncLocalStateHolder;", "disableSync", "disableAndRemoveData", "showError", "message", "", "Lorg/jetbrains/annotations/Nls;", "details", "updateStatusInfo", "getReadableSyncTime", "getUserName", "syncStatusChanged", "disposeUIResources", "getHelpTopic", "LoggedInPredicate", "EnabledPredicate", "SyncEnablerRunning", "AuthServiceRestartPredicate", "DisableResult", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncConfigurable.kt\ncom/intellij/settingsSync/config/SettingsSyncConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,449:1\n1#2:450\n*E\n"})
public final class SettingsSyncConfigurable
extends BoundConfigurable
implements SettingsSyncEnabler.Listener,
SettingsSyncStatusTracker.Listener {
    @NotNull
    public static final DisableResult DisableResult = new DisableResult(null);
    private DialogPanel configPanel;
    private Cell<? extends JButton> enableButton;
    private JLabel statusLabel;
    private volatile boolean marketplacePluginInstalled;
    @NotNull
    private final SettingsSyncEnabler syncEnabler = new SettingsSyncEnabler();
    @NotNull
    private final PluginId MARKETPLACE_PLUGIN_ID;
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_REMOVE_DATA_AND_DISABLE = 1;
    public static final int RESULT_DISABLE = 2;

    public SettingsSyncConfigurable() {
        super(SettingsSyncBundle.INSTANCE.message("title.settings.sync", new Object[0]), null, 2, null);
        PluginId pluginId = PluginId.getId((String)"com.intellij.marketplace");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        this.MARKETPLACE_PLUGIN_ID = pluginId;
        this.syncEnabler.addListener(this);
        SettingsSyncStatusTracker.Companion.getInstance().addListener(this);
    }

    @NotNull
    public DialogPanel createPanel() {
        DialogPanel syncConfigPanel = SettingsSyncPanelFactory.INSTANCE.createCombinedSyncSettingsPanel(SettingsSyncBundle.INSTANCE.message("configurable.what.to.sync.label", new Object[0]), SettingsSyncSettings.Companion.getInstance(), SettingsSyncLocalSettings.Companion.getInstance());
        SettingsSyncAuthService authService = SettingsSyncAuthService.Companion.getInstance();
        boolean authAvailable = authService.isLoginAvailable();
        this.configPanel = BuilderKt.panel(arg_0 -> SettingsSyncConfigurable.createPanel$lambda$16(this, authAvailable, authService, syncConfigPanel, arg_0));
        SettingsSyncEvents settingsSyncEvents = SettingsSyncEvents.Companion.getInstance();
        SettingsSyncEventListener settingsSyncEventListener2 = new SettingsSyncEventListener(this){
            final /* synthetic */ SettingsSyncConfigurable this$0;
            {
                this.this$0 = $receiver;
            }

            public void loginStateChanged() {
                if (SettingsSyncAuthService.Companion.getInstance().isLoggedIn() && !SettingsSyncSettings.Companion.getInstance().getSyncEnabled()) {
                    SettingsSyncConfigurable.access$getSyncEnabler$p(this.this$0).checkServerState();
                }
                this.this$0.reset();
            }
        };
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        settingsSyncEvents.addListener(settingsSyncEventListener2, disposable);
        DialogPanel dialogPanel = this.configPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configPanel");
            dialogPanel = null;
        }
        return dialogPanel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean settingsRepositoryIsEnabled() {
        if (SettingsSyncSettings.Companion.getInstance().getSyncEnabled()) return false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        StreamProvider it = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager().getStreamProvider();
        boolean bl = false;
        if (!it.getEnabled()) return false;
        if (!it.isExclusive()) return false;
        return true;
    }

    @Override
    public void serverStateCheckFinished(@NotNull UpdateResult state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        UpdateResult updateResult = state;
        if (Intrinsics.areEqual((Object)updateResult, (Object)UpdateResult.NoFileOnServer.INSTANCE) || Intrinsics.areEqual((Object)updateResult, (Object)UpdateResult.FileDeletedFromServer.INSTANCE)) {
            this.showEnableSyncDialog(null, null);
        } else if (updateResult instanceof UpdateResult.Success) {
            this.showEnableSyncDialog(((UpdateResult.Success)state).getSettingsSnapshot().getState(), new SettingsSyncLocalStateHolder(((UpdateResult.Success)state).isCrossIdeSyncEnabled()));
        } else if (updateResult instanceof UpdateResult.Error) {
            if (!Intrinsics.areEqual((Object)state, (Object)SettingsSyncEnabler.State.INSTANCE.getCANCELLED())) {
                this.showError(SettingsSyncBundle.INSTANCE.message("notification.title.update.error", new Object[0]), ((UpdateResult.Error)state).getMessage());
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void updateFromServerFinished(@NotNull UpdateResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        UpdateResult updateResult = result;
        if (updateResult instanceof UpdateResult.Success) {
            this.reset();
            SettingsSyncSettings.Companion.getInstance().setSyncEnabled(true);
        } else if (Intrinsics.areEqual((Object)updateResult, (Object)UpdateResult.NoFileOnServer.INSTANCE) || Intrinsics.areEqual((Object)updateResult, (Object)UpdateResult.FileDeletedFromServer.INSTANCE)) {
            this.showError(SettingsSyncBundle.INSTANCE.message("notification.title.update.error", new Object[0]), SettingsSyncBundle.INSTANCE.message("notification.title.update.no.such.file", new Object[0]));
        } else if (updateResult instanceof UpdateResult.Error) {
            this.showError(SettingsSyncBundle.INSTANCE.message("notification.title.update.error", new Object[0]), ((UpdateResult.Error)result).getMessage());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.updateStatusInfo();
    }

    private final void showEnableSyncDialog(SettingsSyncState remoteSettings, SettingsSyncLocalStateHolder remoteSyncScopeSettings) {
        block9: {
            block8: {
                DialogPanel dialogPanel = this.configPanel;
                if (dialogPanel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"configPanel");
                    dialogPanel = null;
                }
                EnableSettingsSyncDialog dialog = new EnableSettingsSyncDialog((JComponent)dialogPanel, remoteSettings, remoteSyncScopeSettings);
                dialog.show();
                EnableSettingsSyncDialog.Result dialogResult = dialog.getResult();
                if (dialogResult == null) break block8;
                EnableSettingsSyncDialog.Result result = dialogResult;
                switch (WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
                    case 1: {
                        this.syncEnabler.getSettingsFromServer(dialog.getSyncSettings());
                        SettingsSyncEventsStatistics.INSTANCE.getENABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.EnabledMethod.GET_FROM_SERVER);
                        break block9;
                    }
                    case 2: {
                        SettingsSyncSettings.Companion.getInstance().setSyncEnabled(true);
                        this.syncEnabler.pushSettingsToServer();
                        if (remoteSettings != null) {
                            SettingsSyncEventsStatistics.INSTANCE.getENABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.EnabledMethod.PUSH_LOCAL);
                        } else {
                            SettingsSyncEventsStatistics.INSTANCE.getENABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.EnabledMethod.PUSH_LOCAL_WAS_ONLY_WAY);
                        }
                        break block9;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            SettingsSyncEventsStatistics.INSTANCE.getENABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.EnabledMethod.CANCELED);
        }
        this.reset();
        DialogPanel dialogPanel = this.configPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configPanel");
            dialogPanel = null;
        }
        dialogPanel.reset();
    }

    private final void disableSync() {
        String[] stringArray = new String[]{Messages.getCancelButton(), SettingsSyncBundle.INSTANCE.message("disable.dialog.disable.button", new Object[0])};
        int result = Messages.showCheckboxMessageDialog((String)SettingsSyncBundle.INSTANCE.message("disable.dialog.text", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("disable.dialog.title", new Object[0]), (String[])stringArray, (String)SettingsSyncBundle.INSTANCE.message("disable.dialog.remove.data.box", new Object[0]), (boolean)false, (int)1, (int)1, (Icon)Messages.getInformationIcon(), (arg_0, arg_1) -> SettingsSyncConfigurable.disableSync$lambda$19(SettingsSyncConfigurable::disableSync$lambda$18, arg_0, arg_1));
        switch (result) {
            case 2: {
                SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
                this.updateStatusInfo();
                SettingsSyncEventsStatistics.INSTANCE.getDISABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.ManualDisableMethod.DISABLED_ONLY);
                break;
            }
            case 1: {
                this.disableAndRemoveData();
                SettingsSyncEventsStatistics.INSTANCE.getDISABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.ManualDisableMethod.DISABLED_AND_REMOVED_DATA_FROM_SERVER);
                break;
            }
            case 0: {
                SettingsSyncEventsStatistics.INSTANCE.getDISABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.ManualDisableMethod.CANCEL);
            }
        }
    }

    private final void disableAndRemoveData() {
        ModalityState modalityState = ModalityState.current();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
        ModalityState modality = modalityState;
        String string = SettingsSyncBundle.INSTANCE.message("disable.remove.data.title", new Object[0]);
        new Task.Modal(modality, this, string){
            final /* synthetic */ ModalityState $modality;
            final /* synthetic */ SettingsSyncConfigurable this$0;
            {
                this.$modality = $modality;
                this.this$0 = $receiver;
                super(null, $super_call_param$1, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                CountDownLatch cdl = new CountDownLatch(1);
                SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(new SyncSettingsEvent.DeleteServerData((Function1<? super DeleteServerDataResult, Unit>)((Function1)arg_0 -> disableAndRemoveData.1.run$lambda$2(cdl, this.$modality, this.this$0, arg_0))));
                cdl.await(1L, TimeUnit.MINUTES);
            }

            private static final Unit run$lambda$2$lambda$0(SettingsSyncConfigurable this$0, DeleteServerDataResult $result) {
                SettingsSyncConfigurable.access$showError(this$0, SettingsSyncBundle.INSTANCE.message("disable.remove.data.failure", new Object[0]), ((DeleteServerDataResult.Error)$result).getError());
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$2$lambda$1(SettingsSyncConfigurable this$0) {
                SettingsSyncConfigurable.access$updateStatusInfo(this$0);
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$2(CountDownLatch $cdl, ModalityState $modality, SettingsSyncConfigurable this$0, DeleteServerDataResult result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                $cdl.countDown();
                DeleteServerDataResult deleteServerDataResult = result;
                if (deleteServerDataResult instanceof DeleteServerDataResult.Error) {
                    ActionsKt.runInEdt$default(null, () -> disableAndRemoveData.1.run$lambda$2$lambda$0(this$0, result), (int)1, null);
                } else if (Intrinsics.areEqual((Object)deleteServerDataResult, (Object)DeleteServerDataResult.Success.INSTANCE)) {
                    ActionsKt.runInEdt((ModalityState)$modality, () -> disableAndRemoveData.1.run$lambda$2$lambda$1(this$0));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
            }
        }.queue();
    }

    private final void showError(String message, String details) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(SettingsSyncBundle.INSTANCE.message("sync.status.failed", new Object[0]));
        JLabel jLabel = this.statusLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
            jLabel = null;
        }
        jLabel.setIcon(AllIcons.General.Error);
        messageBuilder.append(' ').append(message + ": " + details);
        JLabel jLabel2 = this.statusLabel;
        if (jLabel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
            jLabel2 = null;
        }
        jLabel2.setText(messageBuilder.toString());
    }

    private final void updateStatusInfo() {
        if (this.statusLabel != null) {
            JLabel jLabel;
            StringBuilder messageBuilder = new StringBuilder();
            JLabel jLabel2 = this.statusLabel;
            if (jLabel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
                jLabel2 = null;
            }
            jLabel2.setIcon(null);
            if (SettingsSyncSettings.Companion.getInstance().getSyncEnabled()) {
                SettingsSyncStatusTracker statusTracker = SettingsSyncStatusTracker.Companion.getInstance();
                if (statusTracker.isSyncSuccessful()) {
                    messageBuilder.append(SettingsSyncBundle.INSTANCE.message("sync.status.enabled", new Object[0]));
                    if (statusTracker.isSynced()) {
                        Object[] objectArray = new Object[]{this.getReadableSyncTime(), this.getUserName()};
                        messageBuilder.append(". ").append(SettingsSyncBundle.INSTANCE.message("sync.status.last.sync.message", objectArray));
                    }
                    v1 = Unit.INSTANCE;
                } else {
                    messageBuilder.append(SettingsSyncBundle.INSTANCE.message("sync.status.failed", new Object[0]));
                    JLabel jLabel3 = this.statusLabel;
                    if (jLabel3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
                        jLabel3 = null;
                    }
                    jLabel3.setIcon(AllIcons.General.Error);
                    v1 = messageBuilder.append(' ').append(statusTracker.getErrorMessage());
                }
            } else {
                v1 = messageBuilder.append(SettingsSyncBundle.INSTANCE.message("sync.status.disabled", new Object[0]));
            }
            if ((jLabel = this.statusLabel) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
                jLabel = null;
            }
            jLabel.setText(messageBuilder.toString());
        }
    }

    private final String getReadableSyncTime() {
        String string = DateFormatUtil.formatPrettyDateTime((long)SettingsSyncStatusTracker.Companion.getInstance().getLastSyncTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatPrettyDateTime(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    private final String getUserName() {
        Object object = SettingsSyncAuthService.Companion.getInstance().getUserData();
        if (object == null || (object = object.loginName) == null) {
            object = "?";
        }
        return object;
    }

    @Override
    public void syncStatusChanged() {
        this.updateStatusInfo();
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        SettingsSyncStatusTracker.Companion.getInstance().removeListener(this);
    }

    @NotNull
    public String getHelpTopic() {
        return "cloud-config.plugin-dialog";
    }

    private static final Unit createPanel$lambda$16$lambda$1$lambda$0(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setIcon(AllIcons.General.Warning);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16$lambda$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(SettingsSyncBundle.INSTANCE.message("settings.warning.sync.cannot.be.enabled.label", new Object[0])).applyToComponent(SettingsSyncConfigurable::createPanel$lambda$16$lambda$1$lambda$0);
        $this$row.bottomGap(BottomGap.MEDIUM);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16$lambda$2(SettingsSyncConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell statusCell = $this$row.label("");
        statusCell.visibleIf((ComponentPredicate)this$0.new LoggedInPredicate()).enabled(!this$0.settingsRepositoryIsEnabled());
        this$0.statusLabel = (JLabel)statusCell.getComponent();
        this$0.updateStatusInfo();
        $this$row.label(SettingsSyncBundle.INSTANCE.message("sync.status.login.message", new Object[0])).visibleIf(ComponentPredicateKt.not((ComponentPredicate)this$0.new LoggedInPredicate())).enabled(!this$0.settingsRepositoryIsEnabled());
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16$lambda$6$lambda$3(SettingsSyncAuthService $authService, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $authService.login();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16$lambda$6$lambda$4(SettingsSyncConfigurable this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.syncEnabler.checkServerState();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16$lambda$6$lambda$5(SettingsSyncConfigurable this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ComponentPredicateKt.and((ComponentPredicate)this$0.new LoggedInPredicate(), (ComponentPredicate)this$0.new EnabledPredicate());
        this$0.disableSync();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16$lambda$6(SettingsSyncConfigurable this$0, ComponentPredicate $isSyncEnabled, SettingsSyncAuthService $authService, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button(SettingsSyncBundle.INSTANCE.message("config.button.login", new Object[0]), arg_0 -> SettingsSyncConfigurable.createPanel$lambda$16$lambda$6$lambda$3($authService, arg_0)).visibleIf(ComponentPredicateKt.not((ComponentPredicate)this$0.new LoggedInPredicate())).enabled(!this$0.settingsRepositoryIsEnabled());
        this$0.enableButton = $this$row.button(SettingsSyncBundle.INSTANCE.message("config.button.enable", new Object[0]), arg_0 -> SettingsSyncConfigurable.createPanel$lambda$16$lambda$6$lambda$4(this$0, arg_0)).visibleIf(ComponentPredicateKt.and((ComponentPredicate)this$0.new LoggedInPredicate(), (ComponentPredicate)ComponentPredicateKt.not((ComponentPredicate)this$0.new EnabledPredicate()))).enabledIf(ComponentPredicateKt.not((ComponentPredicate)this$0.new SyncEnablerRunning())).enabled(!this$0.settingsRepositoryIsEnabled());
        $this$row.button(SettingsSyncBundle.INSTANCE.message("config.button.disable", new Object[0]), arg_0 -> SettingsSyncConfigurable.createPanel$lambda$16$lambda$6$lambda$5(this$0, arg_0)).visibleIf($isSyncEnabled);
        $this$row.bottomGap(BottomGap.MEDIUM);
        return Unit.INSTANCE;
    }

    private static final void createPanel$lambda$16$lambda$9$lambda$8$lambda$7(Configurable $pluginManager) {
        ((PluginManagerConfigurable)$pluginManager).openMarketplaceTab("/organization:JetBrains Marketplace Licensing");
    }

    private static final Unit createPanel$lambda$16$lambda$9$lambda$8(ActionEvent it) {
        Configurable pluginManager;
        Settings settings;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataManager dataManager = DataManager.getInstance();
        Object object = it.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ui.components.ActionLink");
        DataContext dataContext = dataManager.getDataContext((Component)((ActionLink)object));
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Settings settings2 = settings = (Settings)Settings.KEY.getData(dataContext);
        Object object2 = pluginManager = settings2 != null ? settings2.find("preferences.pluginManager") : null;
        if (pluginManager instanceof PluginManagerConfigurable) {
            settings.select(pluginManager).doWhenDone(() -> SettingsSyncConfigurable.createPanel$lambda$16$lambda$9$lambda$8$lambda$7(pluginManager));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16$lambda$9(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(SettingsSyncBundle.INSTANCE.message("sync.status.login.not.available", new Object[0])).gap(RightGap.SMALL);
        $this$row.link("JetBrains Marketplace Licensing Support", SettingsSyncConfigurable::createPanel$lambda$16$lambda$9$lambda$8);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16$lambda$10(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()};
        $this$row.label(SettingsSyncBundle.INSTANCE.message("sync.status.restart.required", objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16$lambda$12$lambda$11(ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
        ApplicationEx app = (ApplicationEx)application;
        app.restart(true);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16$lambda$12(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button(SettingsSyncBundle.INSTANCE.message("sync.status.restart.ide.button", new Object[0]), SettingsSyncConfigurable::createPanel$lambda$16$lambda$12$lambda$11);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16$lambda$13(ComponentPredicate $isSyncEnabled, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comment$default((Row)$this$row, (String)SettingsSyncBundle.INSTANCE.message("settings.sync.info.message", new Object[0]), (int)80, null, (int)4, null).visibleIf(ComponentPredicateKt.not((ComponentPredicate)$isSyncEnabled));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16$lambda$15$lambda$14(DialogPanel $syncConfigPanel) {
        $syncConfigPanel.apply();
        SettingsSyncEvents.Companion.getInstance().fireCategoriesChanged();
        SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(new SyncSettingsEvent.CrossIdeSyncStateChanged(SettingsSyncLocalSettings.Companion.getInstance().isCrossIdeSyncEnabled()));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16$lambda$15(DialogPanel $syncConfigPanel, SettingsSyncConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$syncConfigPanel).visibleIf(ComponentPredicateKt.and((ComponentPredicate)this$0.new LoggedInPredicate(), (ComponentPredicate)this$0.new EnabledPredicate())).onApply(() -> SettingsSyncConfigurable.createPanel$lambda$16$lambda$15$lambda$14($syncConfigPanel)).onReset((Function0)new Function0<Unit>((Object)$syncConfigPanel){

            public final void invoke() {
                ((DialogPanel)this.receiver).reset();
            }
        }).onIsModified((Function0)new Function0<Boolean>((Object)$syncConfigPanel){

            public final Boolean invoke() {
                return ((DialogPanel)this.receiver).isModified();
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$16(SettingsSyncConfigurable this$0, boolean $authAvailable, SettingsSyncAuthService $authService, DialogPanel $syncConfigPanel, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        ComponentPredicate isSyncEnabled = ComponentPredicateKt.and((ComponentPredicate)this$0.new LoggedInPredicate(), (ComponentPredicate)this$0.new EnabledPredicate());
        if (this$0.settingsRepositoryIsEnabled()) {
            Panel.row$default((Panel)$this$panel, null, SettingsSyncConfigurable::createPanel$lambda$16$lambda$1, (int)1, null);
        }
        if ($authAvailable) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> SettingsSyncConfigurable.createPanel$lambda$16$lambda$2(this$0, arg_0), (int)1, null);
            v0 = Panel.row$default((Panel)$this$panel, null, arg_0 -> SettingsSyncConfigurable.createPanel$lambda$16$lambda$6(this$0, isSyncEnabled, $authService, arg_0), (int)1, null);
        } else {
            AuthServiceRestartPredicate authServiceRestartPredicate = this$0.new AuthServiceRestartPredicate();
            Panel.row$default((Panel)$this$panel, null, SettingsSyncConfigurable::createPanel$lambda$16$lambda$9, (int)1, null).visibleIf(ComponentPredicateKt.not((ComponentPredicate)authServiceRestartPredicate));
            Panel.row$default((Panel)$this$panel, null, SettingsSyncConfigurable::createPanel$lambda$16$lambda$10, (int)1, null).visibleIf((ComponentPredicate)authServiceRestartPredicate);
            v0 = Panel.row$default((Panel)$this$panel, null, SettingsSyncConfigurable::createPanel$lambda$16$lambda$12, (int)1, null).visibleIf((ComponentPredicate)authServiceRestartPredicate);
        }
        Panel.row$default((Panel)$this$panel, null, arg_0 -> SettingsSyncConfigurable.createPanel$lambda$16$lambda$13(isSyncEnabled, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> SettingsSyncConfigurable.createPanel$lambda$16$lambda$15($syncConfigPanel, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Integer disableSync$lambda$18(int index, JCheckBox checkbox) {
        Intrinsics.checkNotNullParameter((Object)checkbox, (String)"checkbox");
        return index == 1 ? Integer.valueOf(checkbox.isSelected() ? 1 : 2) : Integer.valueOf(0);
    }

    private static final Integer disableSync$lambda$19(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ DialogPanel access$getConfigPanel$p(SettingsSyncConfigurable $this) {
        return $this.configPanel;
    }

    public static final /* synthetic */ void access$showError(SettingsSyncConfigurable $this, String message, String details) {
        $this.showError(message, details);
    }

    public static final /* synthetic */ void access$updateStatusInfo(SettingsSyncConfigurable $this) {
        $this.updateStatusInfo();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0016J\u000e\u0010\t\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$AuthServiceRestartPredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "<init>", "(Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;)V", "addListener", "", "listener", "Lkotlin/Function1;", "", "invoke", "()Ljava/lang/Boolean;", "intellij.settingsSync"})
    public final class AuthServiceRestartPredicate
    extends ComponentPredicate {
        public AuthServiceRestartPredicate() {
            SettingsSyncConfigurable.this.marketplacePluginInstalled = InstalledPluginsState.getInstance().wasInstalled(SettingsSyncConfigurable.this.MARKETPLACE_PLUGIN_ID);
        }

        public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            PluginStateManager.addStateListener(arg_0 -> AuthServiceRestartPredicate.addListener$lambda$0(SettingsSyncConfigurable.this, listener, arg_0));
        }

        @NotNull
        public Boolean invoke() {
            return SettingsSyncConfigurable.this.marketplacePluginInstalled;
        }

        private static final void addListener$lambda$0(SettingsSyncConfigurable this$0, Function1 $listener, IdeaPluginDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (Intrinsics.areEqual((Object)descriptor.getPluginId(), (Object)this$0.MARKETPLACE_PLUGIN_ID)) {
                this$0.marketplacePluginInstalled = true;
                $listener.invoke((Object)this$0.marketplacePluginInstalled);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$DisableResult;", "", "<init>", "()V", "RESULT_CANCEL", "", "RESULT_REMOVE_DATA_AND_DISABLE", "RESULT_DISABLE", "intellij.settingsSync"})
    public static final class DisableResult {
        private DisableResult() {
        }

        public /* synthetic */ DisableResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0016J\u000e\u0010\t\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$EnabledPredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "<init>", "(Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;)V", "addListener", "", "listener", "Lkotlin/Function1;", "", "invoke", "()Ljava/lang/Boolean;", "intellij.settingsSync"})
    public final class EnabledPredicate
    extends ComponentPredicate {
        public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            SettingsSyncEvents settingsSyncEvents = SettingsSyncEvents.Companion.getInstance();
            SettingsSyncEventListener settingsSyncEventListener2 = new SettingsSyncEventListener(listener, this, SettingsSyncConfigurable.this){
                final /* synthetic */ Function1<Boolean, Unit> $listener;
                final /* synthetic */ EnabledPredicate this$0;
                final /* synthetic */ SettingsSyncConfigurable this$1;
                {
                    this.$listener = $listener;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void enabledStateChanged(boolean syncEnabled) {
                    this.$listener.invoke((Object)this.this$0.invoke());
                    DialogPanel dialogPanel = SettingsSyncConfigurable.access$getConfigPanel$p(this.this$1);
                    if (dialogPanel == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"configPanel");
                        dialogPanel = null;
                    }
                    dialogPanel.reset();
                }
            };
            Disposable disposable = SettingsSyncConfigurable.this.getDisposable();
            Intrinsics.checkNotNull((Object)disposable);
            settingsSyncEvents.addListener(settingsSyncEventListener2, disposable);
        }

        @NotNull
        public Boolean invoke() {
            return SettingsSyncSettings.Companion.getInstance().getSyncEnabled();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0016J\u000e\u0010\t\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$LoggedInPredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "<init>", "(Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;)V", "addListener", "", "listener", "Lkotlin/Function1;", "", "invoke", "()Ljava/lang/Boolean;", "intellij.settingsSync"})
    public final class LoggedInPredicate
    extends ComponentPredicate {
        public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            SettingsSyncEvents settingsSyncEvents = SettingsSyncEvents.Companion.getInstance();
            SettingsSyncEventListener settingsSyncEventListener2 = new SettingsSyncEventListener(listener, this){
                final /* synthetic */ Function1<Boolean, Unit> $listener;
                final /* synthetic */ LoggedInPredicate this$0;
                {
                    this.$listener = $listener;
                    this.this$0 = $receiver;
                }

                public void loginStateChanged() {
                    this.$listener.invoke((Object)this.this$0.invoke());
                }
            };
            Disposable disposable = SettingsSyncConfigurable.this.getDisposable();
            Intrinsics.checkNotNull((Object)disposable);
            settingsSyncEvents.addListener(settingsSyncEventListener2, disposable);
        }

        @NotNull
        public Boolean invoke() {
            return SettingsSyncAuthService.Companion.getInstance().isLoggedIn();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\tH\u0016J$\u0010\n\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\u000b\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$SyncEnablerRunning;", "Lcom/intellij/ui/layout/ComponentPredicate;", "<init>", "(Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;)V", "isRunning", "", "addListener", "", "listener", "Lkotlin/Function1;", "updateRunning", "invoke", "()Ljava/lang/Boolean;", "intellij.settingsSync"})
    public final class SyncEnablerRunning
    extends ComponentPredicate {
        private boolean isRunning;

        public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            SettingsSyncConfigurable.this.syncEnabler.addListener(new SettingsSyncEnabler.Listener(this, listener){
                final /* synthetic */ SyncEnablerRunning this$0;
                final /* synthetic */ Function1<Boolean, Unit> $listener;
                {
                    this.this$0 = $receiver;
                    this.$listener = $listener;
                }

                public void serverRequestStarted() {
                    SyncEnablerRunning.access$updateRunning(this.this$0, this.$listener, true);
                }

                public void serverRequestFinished() {
                    SyncEnablerRunning.access$updateRunning(this.this$0, this.$listener, false);
                }
            });
        }

        private final void updateRunning(Function1<? super Boolean, Unit> listener, boolean isRunning) {
            this.isRunning = isRunning;
            listener.invoke((Object)this.invoke());
        }

        @NotNull
        public Boolean invoke() {
            return this.isRunning;
        }

        public static final /* synthetic */ void access$updateRunning(SyncEnablerRunning $this, Function1 listener, boolean isRunning) {
            $this.updateRunning((Function1<? super Boolean, Unit>)listener, isRunning);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EnableSettingsSyncDialog.Result.values().length];
            try {
                nArray[EnableSettingsSyncDialog.Result.GET_FROM_SERVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnableSettingsSyncDialog.Result.PUSH_LOCAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

