/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base;

import com.sun.tools.javac.util.Context;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.base.AnnotationProcessingKt;
import org.jetbrains.kotlin.kapt3.base.KaptContext;
import org.jetbrains.kotlin.kapt3.base.KaptFlag;
import org.jetbrains.kotlin.kapt3.base.KaptFlags;
import org.jetbrains.kotlin.kapt3.base.KaptOptions;
import org.jetbrains.kotlin.kapt3.base.KaptOptionsKt;
import org.jetbrains.kotlin.kapt3.base.LoadedProcessors;
import org.jetbrains.kotlin.kapt3.base.ProcessorLoader;
import org.jetbrains.kotlin.kapt3.base.util.KaptLogger;
import org.jetbrains.kotlin.kapt3.base.util.ModuleManipulationUtilsKt;
import org.jetbrains.kotlin.kapt3.base.util.WriterBackedKaptLogger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/Kapt;", "", "<init>", "()V", "JAVAC_CONTEXT_CLASS", "", "kaptFlags", "Lorg/jetbrains/kotlin/kapt3/base/KaptFlags;", "rawFlags", "", "kapt", "", "options", "Lorg/jetbrains/kotlin/kapt3/base/KaptOptions;", "checkJavacComponentsAccess", "logger", "Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;", "findClassLoaderWithJavac", "Ljava/lang/ClassLoader;", "kotlin-annotation-processing-base"})
@SourceDebugExtension(value={"SMAP\nKapt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Kapt.kt\norg/jetbrains/kotlin/kapt3/base/Kapt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 KaptLogger.kt\norg/jetbrains/kotlin/kapt3/base/util/KaptLoggerKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,74:1\n4344#2,2:75\n25#3,4:77\n25#3,4:87\n17#4,6:81\n*S KotlinDebug\n*F\n+ 1 Kapt.kt\norg/jetbrains/kotlin/kapt3/base/Kapt\n*L\n21#1:75,2\n36#1:77,4\n53#1:87,4\n45#1:81,6\n*E\n"})
public final class Kapt {
    @NotNull
    public static final Kapt INSTANCE = new Kapt();
    @NotNull
    private static final String JAVAC_CONTEXT_CLASS = "com.sun.tools.javac.util.Context";

    private Kapt() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final KaptFlags kaptFlags(@NotNull Set<String> rawFlags) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(rawFlags, (String)"rawFlags");
        KaptFlag[] kaptFlagArray = KaptFlag.values();
        Collection collection = new LinkedHashSet();
        KaptFlags.Companion companion = KaptFlags.Companion;
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv).length;
        for (int i = 0; i < n; ++i) {
            void destination$iv;
            void element$iv;
            void it = element$iv = $this$filterTo$iv[i];
            boolean bl = false;
            if (!rawFlags.contains(it.name())) continue;
            destination$iv.add(element$iv);
        }
        return companion.fromSet((Set)collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean kapt(@NotNull KaptOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        ModuleManipulationUtilsKt.doOpenInternalPackagesIfRequired();
        WriterBackedKaptLogger logger = new WriterBackedKaptLogger(options.get(KaptFlag.VERBOSE), null, null, null, 14, null);
        if (!INSTANCE.checkJavacComponentsAccess(logger)) {
            return false;
        }
        Closeable closeable = new KaptContext(options, false, logger);
        Throwable throwable = null;
        try {
            KaptContext kaptContext = (KaptContext)closeable;
            boolean bl = false;
            KaptLogger $this$info$iv = logger;
            boolean $i$f$info = false;
            if ($this$info$iv.isVerbose()) {
                KaptLogger kaptLogger = $this$info$iv;
                boolean bl2 = false;
                kaptLogger.info(KaptOptionsKt.logString(options, "stand-alone mode"));
            }
            List<File> javaSourceFiles = KaptOptionsKt.collectJavaSourceFiles(options, kaptContext.getSourcesToReprocess());
            ProcessorLoader processorLoader = new ProcessorLoader(options, logger);
            Closeable closeable2 = processorLoader;
            Throwable throwable2 = null;
            try {
                ProcessorLoader it = (ProcessorLoader)closeable2;
                boolean bl3 = false;
                LoadedProcessors processors = processorLoader.loadProcessors(INSTANCE.findClassLoaderWithJavac());
                boolean $i$f$measureTimeMillis = false;
                long start$iv = System.currentTimeMillis();
                boolean bl4 = false;
                AnnotationProcessingKt.doAnnotationProcessing(kaptContext, javaSourceFiles, processors.getProcessors(), KaptOptionsKt.collectAggregatedTypes(kaptContext.getSourcesToReprocess()));
                long annotationProcessingTime = System.currentTimeMillis() - start$iv;
                KaptLogger $this$info$iv2 = logger;
                boolean $i$f$info2 = false;
                if ($this$info$iv2.isVerbose()) {
                    KaptLogger kaptLogger = $this$info$iv2;
                    boolean bl5 = false;
                    kaptLogger.info("Annotation processing took " + annotationProcessingTime + " ms");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    public final boolean checkJavacComponentsAccess(@NotNull KaptLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        try {
            Class.forName(JAVAC_CONTEXT_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.error("'com.sun.tools.javac.util.Context' class can't be found ('tools.jar' is absent in the plugin classpath). Kapt won't work.");
            return false;
        }
    }

    private final ClassLoader findClassLoaderWithJavac() {
        ClassLoader classLoader = Context.class.getClassLoader();
        if (classLoader == null) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getSystemClassLoader(...)");
        }
        return classLoader;
    }
}

