/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Graphics;
import java.io.IOException;
import java.util.function.Supplier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.swing.ImageIcon;
import org.rrd4j.data.DataProcessor;
import org.rrd4j.graph.BufferedImageWorker;
import org.rrd4j.graph.ImageParameters;
import org.rrd4j.graph.ImageWorker;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.RrdGraphGenerator;
import org.rrd4j.graph.RrdGraphInfo;

public class RrdGraph
implements RrdGraphConstants {
    final RrdGraphDef gdef;
    final ImageParameters im;
    private final RrdGraphInfo info;

    public RrdGraph(RrdGraphDef gdef) throws IOException {
        this(gdef, () -> RrdGraph.generateImageWorker(gdef));
    }

    public RrdGraph(RrdGraphDef gdef, ImageWorker worker) throws IOException {
        this(gdef, () -> worker);
    }

    public RrdGraph(RrdGraphDef gdef, ImageWriter writer, ImageWriteParam param) throws IOException {
        this(gdef, () -> RrdGraph.generateImageWorker(gdef, writer, param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RrdGraph(RrdGraphDef gdef, Supplier<ImageWorker> worker) throws IOException {
        this.gdef = gdef;
        RrdGraphGenerator generator = new RrdGraphGenerator(gdef, worker.get(), new DataProcessor(gdef.startTime, gdef.endTime));
        try {
            generator.createGraph();
        }
        finally {
            generator.worker.dispose();
        }
        this.info = generator.info;
        this.im = generator.im;
    }

    private static ImageWorker generateImageWorker(RrdGraphDef gdef, ImageWriter writer, ImageWriteParam param) {
        return BufferedImageWorker.getBuilder().setGdef(gdef).setWriter(writer).setImageWriteParam(param).build();
    }

    private static ImageWorker generateImageWorker(RrdGraphDef gdef) {
        return BufferedImageWorker.getBuilder().setGdef(gdef).build();
    }

    public RrdGraphInfo getRrdGraphInfo() {
        return this.info;
    }

    public void render(Graphics g) {
        byte[] imageData = this.getRrdGraphInfo().getBytes();
        ImageIcon image = new ImageIcon(imageData);
        image.paintIcon(null, g, 0, 0);
    }
}

