/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SQLObjectRoot
extends SQLObject {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.unmodifiableList(new ArrayList<Class>(Arrays.asList(SQLDatabase.class, SQLTable.class)));
    private List<SQLDatabase> databases = new ArrayList<SQLDatabase>();
    private List<SQLTable> tables = new ArrayList<SQLTable>();

    @Constructor
    public SQLObjectRoot() {
        this.setName("Database Connections");
    }

    @Override
    @Transient
    @Accessor
    public String getShortDisplayName() {
        return this.getName();
    }

    @Override
    protected void populateImpl() throws SQLObjectException {
    }

    @Override
    @Transient
    @Accessor
    public boolean isPopulated() {
        return true;
    }

    @Override
    public String toString() {
        return this.getShortDisplayName();
    }

    @Override
    public List<? extends SQLObject> getChildrenWithoutPopulating() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        children.addAll(this.databases);
        children.addAll(this.tables);
        return Collections.unmodifiableList(children);
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof SQLDatabase) {
            return this.removeDatabase((SQLDatabase)child);
        }
        if (child instanceof SQLTable) {
            return this.removeTable((SQLTable)child);
        }
        throw new IllegalArgumentException("Cannot remove children of type " + child.getClass() + " from " + this.getName());
    }

    public boolean removeTable(SQLTable child) {
        if (child.getParent() != this) {
            throw new IllegalStateException("Cannot remove child " + child.getName() + " of type " + child.getClass() + " as its parent is not " + this.getName());
        }
        int index = this.tables.indexOf(child);
        if (index != -1) {
            this.tables.remove(index);
            child.setParent(null);
            this.fireChildRemoved(SQLDatabase.class, child, index);
            return true;
        }
        return false;
    }

    public boolean removeDatabase(SQLDatabase child) {
        if (child.getParent() != this) {
            throw new IllegalStateException("Cannot remove child " + child.getName() + " of type " + child.getClass() + " as its parent is not " + this.getName());
        }
        int index = this.databases.indexOf(child);
        if (index != -1) {
            this.databases.remove(index);
            this.fireChildRemoved(SQLDatabase.class, child, index);
            child.setParent(null);
            child.disconnect();
            return true;
        }
        return false;
    }

    @Override
    @NonProperty
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void removeDependency(SPObject dependency) {
        for (SQLObject sQLObject : this.getChildren()) {
            sQLObject.removeDependency(dependency);
        }
    }

    @Override
    protected void addChildImpl(SPObject child, int index) {
        if (child instanceof SQLDatabase) {
            this.addDatabase((SQLDatabase)child, index);
        } else if (child instanceof SQLTable) {
            this.addTable((SQLTable)child, index);
        } else {
            throw new IllegalArgumentException("The child " + child.getName() + " of type " + child.getClass() + " is not a valid child type of " + this.getClass() + ".");
        }
    }

    public void addDatabase(SQLDatabase child, int index) {
        this.databases.add(index, child);
        child.setParent(this);
        this.fireChildAdded(SQLDatabase.class, child, index);
    }

    public void addTable(SQLTable child, int index) {
        this.tables.add(index, child);
        child.setParent(this);
        this.fireChildAdded(SQLTable.class, child, index);
    }

    @Override
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }
}

